package com.mmc.pms.controller.service;


import com.mmc.pms.common.ResultBody;
import com.mmc.pms.controller.BaseController;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.work.vo.ServiceOrderTaskVO;
import com.mmc.pms.model.work.vo.ServiceVO;
import com.mmc.pms.service.ServiceOrderTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * 云享飞服务订单-主表
 * </p>
 *
 * @author Pika
 * @since 2023-06-10
 */
@Api(tags = {"云享飞服务订单-模块"})
@RestController
@RequestMapping("/serviceOrderTask")
public class ServiceOrderTaskController extends BaseController {

    @Autowired
    private ServiceOrderTaskService serviceOrderTaskService;

    @ApiOperation(value = "订单任务-新增")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insertOrderTask")
    public ResultBody insertOrderTask(
            @Validated(Create.class) @RequestBody ServiceOrderTaskVO param, HttpServletRequest request) {
        return serviceOrderTaskService.insertOrderTask(param, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }
}

