package com.mmc.pms.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author small @Date 2023/5/25 9:55 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.model.dto.BaseAccountDTO", description = "登录信息DTO")
public class BaseAccountDTO implements Serializable {
  private static final long serialVersionUID = -2979712090903806216L;
  private Integer id;
  private String uid;
  private String accountPhone;
  private String accountNo;
  private String accountName;
  private String tokenPort;

  @ApiModelProperty(value = "角色ID")
  private Integer roleId;

  @ApiModelProperty(value = "是否为管理角色:0否 1是")
  private Integer admin; // 是否为管理角色

  @ApiModelProperty(value = "是否为运营角色:0否 1是")
  private Integer operate;

  @ApiModelProperty(value = "是否PMC发货专员:0否 1是")
  private Integer pmc;

  @ApiModelProperty(value = "单位信息")
  private CompanyCacheDTO companyInfo; // 单位信息

  public BaseAccountDTO(UserAccountDTO user) {
    this.id = user.getId();
    this.accountNo = user.getAccountNo();
    this.accountName = user.getUserName();
    this.roleId = user.getRoleInfo() == null ? null : user.getRoleInfo().getId();
    this.admin = user.getRoleInfo() == null ? null : user.getRoleInfo().getAdmin();
    this.operate = user.getRoleInfo() == null ? null : user.getRoleInfo().getOperate();
    this.pmc = user.getRoleInfo() == null ? null : user.getRoleInfo().getPmc();
  }

  public BaseAccountDTO(RepoAccountDTO account) {
    this.id = account.getId();
    this.accountName = account.getAccountName();
    this.uid = account.getUid();
    this.accountPhone = account.getPhoneNum();
  }

  public BaseAccountDTO(MallUserDTO account) {
    this.id = account.getId();
    this.accountName = account.getNickName();
    this.uid = account.getUid();
    this.accountPhone = account.getPhoneNum();
  }

  public BaseAccountDTO(FlyerAccountDTO account) {
    this.id = account.getId();
    this.accountName = account.getAccountName();
    this.uid = account.getUid();
    this.accountPhone = account.getPhoneNum();
  }

  /**
   * 是否为科比特超级管理员单位(是:无单位资源限制 否:只能看当前和下级单位的资源)
   *
   * @return
   */
  public boolean isManage() {
    if (this.getCompanyInfo() == null) {
      return false;
    }
    if (this.getCompanyInfo().getManage() == null) {
      return false;
    }
    return this.getCompanyInfo().getManage() == 1;
  }

  /**
   * 判断是否已授权
   *
   * @return
   */
  //	public boolean authorized() {
  //		if (StringUtils.isBlank(this.accountName) || StringUtils.isBlank(this.accountPhone)) {
  //			return false;
  //		}
  //		return true;
  //	}
}
