package com.mmc.pms.entity;

import com.mmc.pms.model.dto.AppletWareInfoDTO;
import com.mmc.pms.model.dto.WareInfoDTO;
import com.mmc.pms.model.dto.WareInfoItemDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small @Date 2023/5/16 10:00 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WareInfoDO implements Serializable {
  private static final long serialVersionUID = 5530961803742843304L;
  private Integer id;
  private String wareNo;
  private String wareTitle;
  private Integer wareTypeId;
  private Integer wareStatus;
  private Integer payStatus;
  private BigDecimal minDeposit;
  private BigDecimal maxDeposit;
  private BigDecimal minRent;
  private BigDecimal maxRent;
  private Integer totalStock;
  private Integer totalSale;
  private Integer skuNum;
  private String tags;
  private Integer deleted;
  private Date createTime;
  private Date updateTime;
  private Integer pid;

  /** 辅助字段-start */
  private List<WareImgDO> wareImgs;
  // private List<WareVideoDO> wareVideos;
  private WarePropDO warePropDO;
  private String wareDetailContent;
  // private WareDetailDO wareDetailDO;
  // private List<SkuInfoDO> skuInfoDOList;

  /** 辅助字段-end */
  public WareInfoDTO buildWareInfoDTO() {
    return WareInfoDTO.builder()
        .id(this.id)
        .wareNo(this.wareNo)
        .wareTitle(this.wareTitle)
        .wareTypeId(this.wareTypeId)
        .wareStatus(this.wareStatus)
        .payStatus(this.payStatus)
        .minDeposit(this.minDeposit)
        .maxDeposit(this.maxDeposit)
        .minRent(this.minRent)
        .maxRent(this.maxRent)
        .totalStock(this.totalStock)
        .totalSale(this.totalSale)
        .skuNum(this.skuNum)
        .tags(StringUtils.isEmpty(this.tags) ? null : Arrays.asList(this.tags.split(",")))
        .wareImgs(
            CollectionUtils.isEmpty(this.wareImgs)
                ? null
                : this.wareImgs.stream()
                    .map(
                        d -> {
                          return d.buildWareImgDTO();
                        })
                    .collect(Collectors.toList()))
        .warePropDTO(this.warePropDO == null ? null : warePropDO.buildWarePropDTO())
        .wareDetailContent(this.wareDetailContent)
        .build();
  }

  public WareInfoItemDTO buildWareInfoItemDTO() {
    return WareInfoItemDTO.builder()
        .id(this.id)
        .wareNo(this.wareNo)
        .wareTitle(this.wareTitle)
        .wareTypeId(this.wareTypeId)
        .wareStatus(this.wareStatus)
        .minDeposit(this.minDeposit)
        .minRent(this.minRent)
        .totalStock(this.totalStock)
        .totalSale(this.totalSale)
        .tags(StringUtils.isEmpty(this.tags) ? null : Arrays.asList(this.tags.split(",")))
        .wareImgs(
            CollectionUtils.isEmpty(this.wareImgs)
                ? null
                : this.wareImgs.stream()
                    .map(
                        d -> {
                          return d.buildWareImgDTO();
                        })
                    .collect(Collectors.toList()))
        .propInfoId(this.warePropDO.getPropInfoId())
        .createTime(this.createTime)
        .build();
  }

  public AppletWareInfoDTO buildAppletWareInfoDTO() {
    return AppletWareInfoDTO.builder()
        .id(this.id)
        .wareNo(this.wareNo)
        .wareTitle(this.wareTitle)
        .wareTypeId(this.wareTypeId)
        .wareStatus(this.wareStatus)
        .payStatus(this.payStatus)
        .minDeposit(this.minDeposit)
        .minRent(this.minRent)
        .totalStock(this.totalStock)
        .totalSale(this.totalSale)
        .skuNum(this.skuNum)
        .tags(StringUtils.isEmpty(this.tags) ? null : Arrays.asList(this.tags.split(",")))
        .wareImgs(
            CollectionUtils.isEmpty(this.wareImgs)
                ? null
                : this.wareImgs.stream()
                    .map(
                        d -> {
                          return d.buildWareImgDTO();
                        })
                    .collect(Collectors.toList()))
        .build();
  }
}
