package com.mmc.pms.entity;

import com.mmc.pms.model.dto.SkuPriceDTO;
import com.mmc.pms.model.vo.WareSkuPriceVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author small
 * @Date 2023/5/19 19:55
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SkuPriceDO implements Serializable {
    private static final long serialVersionUID = 3807980441008975420L;
    private Integer id;
    private Integer wareInfoId;
    private Integer skuInfoId;
    private BigDecimal rentPrice;
    private Integer minDay;
    private Integer maxDay;
    private Date createTime;

    public SkuPriceDO(WareSkuPriceVO dd) {
        this.id = dd.getId();
        this.rentPrice = dd.getRentPrice();
        this.minDay = dd.getMinDay();
        this.maxDay = dd.getMaxDay();
    }

    public SkuPriceDTO buildSkuPriceDTO(){
        return SkuPriceDTO.builder().id(this.id).wareInfoId(this.wareInfoId).skuInfoId(this.skuInfoId).rentPrice(this.rentPrice).minDay(this.minDay)
                .maxDay(this.maxDay).createTime(this.createTime).build();
    }
}
