package com.mmc.pms.dao;

import com.mmc.pms.entity.ProductSkuDO;
import com.mmc.pms.entity.ProductSpecDO;
import com.mmc.pms.entity.ProductSpecPriceDO;
import com.mmc.pms.model.dto.ProductSkuVO;
import com.mmc.pms.model.dto.ProductSpecVO;
import com.mmc.pms.model.qo.ProductSkuQO;
import com.mmc.pms.model.vo.ProductSpecCPQVO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @author 23214
 * @description 针对表【product_sku(产品sku表)】的数据库操作Mapper
 * @createDate 2023-05-25 14:55:56
 * @Entity com.mmc.pms.entity.ProductSku
 */
@Mapper
public interface ProductSkuDao {

    int countSkuName(ProductSkuVO param);

    int insertProductSku(ProductSkuDO productSkuDO);

    int countSkuIsExist(Integer id);

    ProductSkuDO getProductSkuDetail(Integer id);

    int updateProductSku(ProductSkuDO productSkuDO);

    int countListPageProductSku(ProductSkuQO productSkuQO);

    List<ProductSkuDO> listPageProductSku(ProductSkuQO productSkuQO);

    int countSpecName(ProductSpecVO param);

    int insertProductSpec(ProductSpecDO productSpecDO);

    int updateProductSpec(ProductSpecDO productSpecDO);

    int countSpecIsExist(Integer id);

    ProductSpecDO getProductSpecDetail(Integer id);

    int countListPageProductSpec(Integer productSkuId);

    List<ProductSpecDO> listPageProductSpec(int i, Integer pageSize, Integer productSkuId);

    int batchInsertSpecPrice(List<ProductSpecPriceDO> list);


    void batchInsertLeaseSpecPrice(List<ProductSpecPriceDO> list);

    void removeProductSpecCPQ(ProductSpecCPQVO productSpecCPQVO);

    List<ProductSpecPriceDO> getProductSpecPrice(ProductSpecCPQVO productSpecCPQVO);
}




