package com.mmc.pms.controller;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.dto.BrandInfoDTO;
import com.mmc.pms.service.BrandManageService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author LW
 * @date 2023/3/14 13:22
 * 概要：
 */
@RestController
@RequestMapping("/brand")
@Api(tags = {"品牌管理-相关接口"})
public class BrandManageController {

    @Autowired
    private BrandManageService brandManageService;

    @ApiOperation(value = "新增品牌")
    @GetMapping("addBrandInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addBrandInfo(@ApiParam(value = "品牌名称") @RequestParam String brandName) {
        return brandManageService.addBrandInfo(brandName);
    }

    @ApiOperation(value = "品牌列表")
    @GetMapping("listBrandInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = BrandInfoDTO.class)})
    public ResultBody listBrandInfo(@RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        return ResultBody.success(brandManageService.listBrandInfo(pageNo, pageSize));
    }

//    @ApiOperation(value = "删除品牌")
//    @GetMapping("deleteBrandInfo")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
//    public ResultBody deleteBrandInfo(Integer id) {
//        return brandManageService.deleteBrandInfo(id);
//    }

    @ApiOperation(value = "编辑品牌")
    @GetMapping("editBrandInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody editBrandInfo(Integer id, String brandName) {
        return brandManageService.editBrandInfo(id, brandName);
    }

}
