package com.mmc.pms.model.qo;


import com.mmc.pms.common.Page;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Freeze;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 云享飞服务订单-主表
 * </p>
 *
 * @author Pika
 * @since 2023-06-10
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ServiceOrderTaskQO implements Serializable {

    private static final long serialVersionUID = -17878654L;


    @ApiModelProperty(value = "订单状态：0 待分配运营")
    private Integer orderStatus;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(
            message = "页码不能为空",
            groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(
            message = "每页显示数不能为空",
            groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
