package com.mmc.pms.controller.service;


import com.mmc.pms.common.Page;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.controller.BaseController;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.qo.ServiceOrderTaskQO;
import com.mmc.pms.model.qo.ServiceQO;
import com.mmc.pms.model.work.dto.ServiceDTO;
import com.mmc.pms.model.work.dto.ServiceOrderTaskDTO;
import com.mmc.pms.model.work.vo.ServiceOrderTaskVO;
import com.mmc.pms.model.work.vo.ServiceVO;
import com.mmc.pms.service.ServiceOrderTaskService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>
 * 云享飞服务订单-主表
 * </p>
 *
 * @author Pika
 * @since 2023-06-10
 */
@Api(tags = {"云享飞作业服务订单-模块"})
@RestController
@RequestMapping("/serviceOrderTask")
public class ServiceOrderTaskController extends BaseController {

    @Autowired
    private ServiceOrderTaskService serviceOrderTaskService;

    @ApiOperation(value = "服务订单任务-新增")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insertOrderTask")
    public ResultBody insertOrderTask(
            @Validated(Create.class) @RequestBody ServiceOrderTaskVO param, HttpServletRequest request) {
        return serviceOrderTaskService.insertOrderTask(param, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "查询服务订单列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ServiceOrderTaskDTO.class)})
    @PostMapping("queryOrderTaskList")
    public ResultBody<ServiceOrderTaskDTO> queryOrderTaskList(
            @Validated(Page.class) @RequestBody ServiceOrderTaskQO param, HttpServletRequest request) {
        return ResultBody.success(serviceOrderTaskService.queryOrderTaskList(param, this.getUserLoginInfoFromRedis(request).getUserAccountId()));
    }

    @ApiOperation(value = "查询服务订单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ServiceOrderTaskDTO.class)})
    @GetMapping("queryOrderTask")
    public ResultBody<ServiceOrderTaskDTO> queryOrderTask(@ApiParam("订单服务id") @RequestParam(value = "id") Integer id) {
        return serviceOrderTaskService.queryById(id);
    }
}

