package com.mmc.pms.controller;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.dto.AdDTO;
import com.mmc.pms.model.dto.AppGoodsInfoDetailDTO;
import com.mmc.pms.model.dto.GoodsInfoListDTO;
import com.mmc.pms.model.dto.ProductCategoryDTO;
import com.mmc.pms.model.qo.GoodsInfoQO;
import com.mmc.pms.service.MiniProgramProductMallService;
import com.mmc.pms.service.WebProductMallService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Author small @Date 2023/5/15 13:24 @Version 1.0
 */
@Api(tags = {"web产品商城-接口"})
@RestController
@RequestMapping("/webProductMall")
public class WebProductMallController {
  @Autowired private WebProductMallService webProductMallService;

  @Autowired private MiniProgramProductMallService miniProgramProductMallService;

  @ApiOperation("产品类目")
  @GetMapping("/category")
  public ResultBody<ProductCategoryDTO> productCategory() {
    return webProductMallService.productCategory();
  }

  @ApiOperation("产品部件")
  @GetMapping("/parts")
  public ResultBody<ProductCategoryDTO> productParts() {
    return webProductMallService.productParts();
  }

  @ApiOperation("产品成色")
  @GetMapping("/quality")
  public ResultBody<ProductCategoryDTO> productQuality() {
    return webProductMallService.productQuality();
  }

  @ApiOperation(value = "web-商品信息-分页")
  @PostMapping("listPageGoodsInfo")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = GoodsInfoListDTO.class)})
  public ResultBody<GoodsInfoListDTO> listPageGoodsInfo(
      @ApiParam("商品查询条件QO") @RequestBody GoodsInfoQO param) {
    return ResultBody.success(webProductMallService.listPageGoodsInfo(param));
  }

  @ApiOperation(value = "web-获取商品详细信息--共多少种选择")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = AppGoodsInfoDetailDTO.class)})
  @GetMapping("getAppGoodsInfoDetail")
  public ResultBody<AppGoodsInfoDetailDTO> getAppGoodsInfoDetail(@RequestParam Integer id) {
    return miniProgramProductMallService.getAppGoodsInfoDetail(id);
  }

  @ApiOperation("产品商城广告位")
  @GetMapping("/ad")
  public ResultBody<AdDTO> ad() {
    return webProductMallService.ad();
  }
}
