package com.mmc.pms.controller;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.dto.AppGoodsInfoDetailDTO;
import com.mmc.pms.model.dto.GoodsInfoListDTO;
import com.mmc.pms.model.qo.GoodsInfoQO;
import com.mmc.pms.service.MiniProgramProductMallService;
import com.mmc.pms.service.WebProductMallService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Author small @Date 2023/5/15 13:23 @Version 1.0
 */
@Api(tags = {"小程序产品商城-接口"})
@RestController
@RequestMapping("/AppProductMall/")
public class MiniProgramProductMallController {

  @Autowired private WebProductMallService webProductMallService;

  @Autowired private MiniProgramProductMallService miniProgramProductMallService;

  @ApiOperation(value = "小程序-商品信息-分页")
  @PostMapping("listPageGoodsInfo")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = GoodsInfoListDTO.class)})
  public ResultBody<GoodsInfoListDTO> listPageGoodsInfo(
      @ApiParam("商品查询条件QO") @RequestBody GoodsInfoQO param) {
    return ResultBody.success(webProductMallService.listPageGoodsInfo(param));
  }

  @ApiOperation(value = "小程序端-获取商品详细信息--共多少种选择")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = AppGoodsInfoDetailDTO.class)})
  @GetMapping("getAppGoodsInfoDetail")
  public ResultBody<AppGoodsInfoDetailDTO> getAppGoodsInfoDetail(@RequestParam Integer id) {
    return miniProgramProductMallService.getAppGoodsInfoDetail(id);
  }
}
