package com.mmc.pms.model.lease.qo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.domain.Page;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author LW
 * @date 2023/8/15 10:47
 * 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LeaseGoodsQO implements Serializable {

    private static final long serialVersionUID = -3779375235771767532L;

    @ApiModelProperty(value = "上架状态 0下架 1上架")
    private Integer shelfStatus;

    @ApiModelProperty(value = "商品标题", example = "商品标题")
    private String tradeName;

    @ApiModelProperty(value = "商品类型id", example = "1")
    private Integer productTypeId;

    @ApiModelProperty(value = "品牌id", example = "2")
    private Integer brandInfoId;

    @ApiModelProperty(value = "用户id", hidden = true)
    private Integer userAccountId;


    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;


    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
