package com.mmc.pms.entity.mall;

import com.mmc.pms.model.mall.SpecAttrVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 规格属性表(SpecAttrDO)实体类
 *
 * @author makejava
 * @since 2023-08-08 14:30:03
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SpecAttrValueDO implements Serializable {
    private static final long serialVersionUID = -59237014539007263L;

    private Integer id;
    /**
     * 商品id
     */
    private Integer specAttrId;
    /**
     * 规格值名称
     */
    private String specValueName;

    private Date createTime;

    public SpecAttrValueDO(SpecAttrVO specAttrVO) {
        specAttrId = specAttrVO.getId();
        specValueName = specAttrVO.getSpecName();
    }

    public SpecAttrVO buildSpecAttr() {
        return SpecAttrVO.builder().id(id).specName(specValueName).build();
    }
}

