package com.mmc.pms.entity.lease;

import com.mmc.pms.model.lease.vo.LeaseGoodsVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 租赁商品信息(LeaseGoodsDO)实体类
 *
 * @author makejava
 * @since 2023-08-11 14:53:01
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LeaseGoodsDO implements Serializable {
    private static final long serialVersionUID = -99441568098401769L;

    private Integer id;
    /**
     * 商品名称
     */
    private String tradeName;
    /**
     * 商品卖点
     */
    private String sellingPoint;
    /**
     * 商品成新
     */
    private Integer level;
    /**
     * 状态：0: 下架 1:上架
     */
    private Integer shelfStatus;
    /**
     * 商品类型
     */
    private Integer productTypeId;
    /**
     * 品牌id
     */
    private Integer brandInfoId;
    /**
     * 型号id
     */
    private Integer deviceModeId;
    /**
     * 商品参数
     */
    private String productParam;
    /**
     * 商品详情
     */
    private String productDetails;
    /**
     * 最短租期
     */
    private Integer minLeaseTerm;
    /**
     * 最长租期
     */
    private Integer maxLeaseTerm;
    /**
     * 发货地址
     */
    private Integer shipAddress;
    /**
     * 归还地址
     */
    private Integer returnAddress;
    /**
     * 寄出物流
     */
    private Integer logisticsCompany;
    /**
     * 配送方式
     */
    private Integer modeOfDelivery;
    /**
     * 上架店铺id
     */
    private Integer userAccountId;

    private Date createTime;

    private Date updateTime;

    private Integer sort;

    /**
     * 辅助字段 begin
     */
    // 图片
    private List<LeaseGoodsResourcesDO> leaseGoodsResources;
    // 规格排列组合
    private List<LeasePriceStockDO> priceStockList;

    /**
     * 辅助字段end
     */

    public LeaseGoodsDO(LeaseGoodsVO leaseGoodsVO) {
        this.id = leaseGoodsVO.getId();
        this.tradeName = leaseGoodsVO.getTradeName();
        this.sellingPoint = leaseGoodsVO.getSellingPoint();
        this.level = leaseGoodsVO.getLevel();
        this.shelfStatus = leaseGoodsVO.getShelfStatus();
        this.productTypeId = leaseGoodsVO.getProductTypeId();
        this.brandInfoId = leaseGoodsVO.getBrandInfoId();
        this.deviceModeId = leaseGoodsVO.getDeviceModeId();
        this.productParam = leaseGoodsVO.getProductParam();
        this.productDetails = leaseGoodsVO.getProductDetails();
        this.minLeaseTerm = leaseGoodsVO.getMinLeaseTerm();
        this.maxLeaseTerm = leaseGoodsVO.getMaxLeaseTerm();
        this.shipAddress = leaseGoodsVO.getShipAddress();
        this.returnAddress = leaseGoodsVO.getReturnAddress();
        this.logisticsCompany = leaseGoodsVO.getLogisticsCompany();
        this.modeOfDelivery = leaseGoodsVO.getModeOfDelivery();
    }

    public LeaseGoodsVO buildLeaseGoodsVO() {
        return LeaseGoodsVO.builder().id(id).tradeName(tradeName)
                .sellingPoint(sellingPoint).level(level).shelfStatus(shelfStatus)
                .productTypeId(productTypeId).brandInfoId(brandInfoId).deviceModeId(deviceModeId)
                .productParam(productParam).productDetails(productDetails).minLeaseTerm(minLeaseTerm)
                .maxLeaseTerm(maxLeaseTerm).shipAddress(shipAddress).returnAddress(returnAddress)
                .logisticsCompany(logisticsCompany).modeOfDelivery(modeOfDelivery).createTime(createTime)
                .userAccountId(userAccountId).resourcesList(CollectionUtils.isEmpty(leaseGoodsResources)
                        ? null : leaseGoodsResources.stream().map(LeaseGoodsResourcesDO::buildGoodsResourcesVO).collect(Collectors.toList()))
                .priceStock(CollectionUtils.isEmpty(priceStockList)
                        ? null : priceStockList.stream().map(LeasePriceStockDO::buildPriceStockVO).collect(Collectors.toList()))
                .build();
    }
}

