package com.mmc.pms.entity;

import com.mmc.pms.model.sale.dto.GoodsDetailInfoDTO;
import com.mmc.pms.model.sale.vo.GoodsDetailVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/16 15:11 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
public class GoodsDetailDO implements Serializable {
    private Integer id;
    private Integer goodsInfoId;
    private String goodsDesc;
    private String content;
    private String remark;
    private Date createTime;
    private Date updateTime;

    public GoodsDetailDO(GoodsDetailVO goodsDetailVO) {
        this.goodsDesc = goodsDetailVO.getGoodsDesc();
        this.content = goodsDetailVO.getProductDesc();
        this.remark = goodsDetailVO.getRemark();
    }

    public GoodsDetailInfoDTO buildGoodsDetailInfoDTO() {
        return GoodsDetailInfoDTO.builder()
                .id(this.id)
                .goodsDesc(this.goodsDesc)
                .content(this.content)
                .remark(this.remark)
                .build();
    }
}
