package com.mmc.pms.model.category.vo;

import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author LW
 * @date 2023/8/5 14:32
 * 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ProductTypeVO implements Serializable {
    private static final long serialVersionUID = -1466513739991843345L;
    @ApiModelProperty(value = "id", example = "1")
    @NotNull(groups = {Update.class}, message = "id不能为空")
    private Integer id;

    @ApiModelProperty(value = "类型名称", example = "航拍无人机")
    @NotEmpty(groups = {Create.class, Update.class}, message = "类型名称不能为空")
    private String name;

    @ApiModelProperty(value = "图标", example = "https://share-fly.oss-cn-hangzhou.aliyuncs.com/file/ad0e77b4-8518-4ecc-9b7f-19218f56b755.png")
    @NotEmpty(groups = {Create.class, Update.class}, message = "图标不能为空")
    private String url;
}
