package com.mmc.pms.model.category.qo;

import com.mmc.pms.common.Page;
import com.mmc.pms.model.group.Freeze;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author LW
 * @date 2023/8/10 11:20
 * 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ModeInfoQO implements Serializable {
    private static final long serialVersionUID = -4803514505953618319L;
    @ApiModelProperty(value = "品牌id", example = "1")
    private Integer brandInfoId;

    @ApiModelProperty(value = "类型id", example = "1")
    private Integer productTypeId;

    @ApiModelProperty(value = "当前页", required = true, example = "1")
    @NotNull(message = "当前页不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "页大小", required = true, example = "10")
    @NotNull(message = "页大小不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }

}
