package com.mmc.pms.controller.category;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.category.vo.ProductTypeVO;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import com.mmc.pms.service.category.ProductAttributeService;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @Author LW
 * @date 2023/8/5 10:35
 * 概要：
 */
@RestController
@RequestMapping("/attribute")
@Api(tags = {"V1.0.3-产品属性-相关接口"})
public class ProductAttributeController {
    @Resource
    ProductAttributeService productAttributeService;

    @ApiOperation(value = "类型新增")
    @PostMapping("/addType")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addType(@RequestBody @Validated(value = {Create.class}) ProductTypeVO param) {
        return productAttributeService.addType(param);
    }

    @ApiOperation(value = "类型编辑")
    @PostMapping("/editType")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody editType(@RequestBody @Validated(value = {Update.class}) ProductTypeVO param) {
        return productAttributeService.editType(param);
    }

    @ApiOperation(value = "类型删除")
    @GetMapping("/removeType")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody removeType(@RequestParam Integer id) {
        return productAttributeService.removeType(id);
    }

    @ApiOperation(value = "类型详情")
    @GetMapping("/typeDetails")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ProductTypeVO.class)})
    public ResultBody<ProductTypeVO> typeDetails(@RequestParam Integer id) {
        return productAttributeService.typeDetails(id);
    }

    @ApiOperation(value = "类型列表")
    @GetMapping("/typeList")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ProductTypeVO.class)})
    public ResultBody<ProductTypeVO> typeList(@RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        return ResultBody.success(productAttributeService.typeList(pageNo, pageSize));
    }

    @ApiOperation(value = "商品列表-排序")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("exchange")
    public ResultBody exchange(@ApiParam(value = "第一个id", required = true) @RequestParam(value = "firstId") Integer firstId,
                               @ApiParam(value = "第二个id", required = true) @RequestParam(value = "secondId") Integer secondId) {
        return productAttributeService.exchange(firstId, secondId);
    }
}
