package com.mmc.pms.model.lease.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author small @Date 2023/5/16 9:53 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "设备列表ItemDTO")
public class WareInfoItemDTO implements Serializable {
  private static final long serialVersionUID = -4354269497656808831L;

  @ApiModelProperty(name = "ID", value = "地域id", required = false, example = "ID")
  private Integer id;

  @ApiModelProperty(name = "ID", value = "商品编号", required = false, example = "商品编号")
  private String wareNo;

  @ApiModelProperty(name = "商品标题", value = "商品标题", required = false, example = "商品标题")
  private String wareTitle;

  @ApiModelProperty(name = "商品类型ID", value = "商品类型ID", required = false, example = "商品类型ID")
  private Integer wareTypeId;

  @ApiModelProperty(name = "商品状态", value = "商品状态", required = false, example = "商品状态")
  private Integer wareStatus;

  @ApiModelProperty(name = "最小押金", value = "最小押金", required = false, example = "最小押金")
  private BigDecimal minDeposit;

  @ApiModelProperty(name = "最小租金", value = "最小租金", required = false, example = "最小租金")
  private BigDecimal minRent;

  @ApiModelProperty(name = "总库存数量", value = "总库存数量", required = false, example = "总库存数量")
  private Integer totalStock;

  @ApiModelProperty(name = "总销量", value = "总销量", required = false, example = "总销量")
  private Integer totalSale;

  @ApiModelProperty(name = "商品活动属性Id", value = "商品活动属性Id", required = false, example = "商品活动属性Id")
  private Integer propInfoId;

  @ApiModelProperty(name = "生成时间", value = "生成时间", required = false, example = "生成时间")
  private Date createTime;

  @ApiModelProperty(name = "商品图片", value = "商品图片", required = false, example = "商品图片")
  private List<WareImgDTO> wareImgs;

  @ApiModelProperty(name = "标签集合", value = "标签集合", required = false, example = "标签集合")
  private List<String> tags;
}
