package com.mmc.pms.model.category.vo;

import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @Author small
 * @Date 2023/7/21 10:10
 * @Version 1.0
 */
@Data
public class CategorySubVO {

    @ApiModelProperty(value = "id", example = "1")
    @NotNull(message = "id不能为空", groups = {Update.class})
    @Min(value = 1, groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "分类名称", required = true, example = "无人机")
    @Size(max = 15, message = "分类名称不能超过15个字", groups = {Update.class, Create.class})
    @NotBlank(message = "分类名称不能为空或空字符", groups = {Update.class, Create.class})
    private String name;

    @ApiModelProperty(value = "描述", example = "描述001")
    @Size(max = 70, message = "分类描述不能超过70个字", groups = {Update.class, Create.class})
    private String description;

    @ApiModelProperty(value = "一级分类id不能为空", required = true, example = "1")
    @NotNull(message = "一级分类id不能为空", groups = {Update.class, Create.class})
    private Integer categoryPrimaryId;
}
