package com.mmc.pms.service.Impl;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.dao.BackstageTaskServiceDao;
import com.mmc.pms.entity.ServiceDO;
import com.mmc.pms.model.qo.ServiceQO;
import com.mmc.pms.model.work.vo.ServiceVO;
import com.mmc.pms.service.BackstageTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Author LW
 * @date 2023/6/8 9:59
 * 概要：
 */
@Service
public class BackstageTaskServiceImpl implements BackstageTaskService {

    @Autowired
    private BackstageTaskServiceDao backstageTaskServiceDao;

    @Override
    public ResultBody addWorkService(ServiceVO param, Integer userAccountId) {
        ServiceDO serviceDO = new ServiceDO(param, userAccountId);
        backstageTaskServiceDao.insert(serviceDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateById(ServiceVO param) {
        ServiceDO serviceDO = new ServiceDO(param);
        backstageTaskServiceDao.update(serviceDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody deleteById(Integer id) {
        backstageTaskServiceDao.deleteById(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody queryById(Integer id) {
        ServiceDO serviceDO = backstageTaskServiceDao.queryById(id);
        return ResultBody.success(serviceDO);
    }

    @Override
    public ResultBody queryWorkServiceList(ServiceQO param, Integer userAccountId) {
        List<ServiceDO> services = backstageTaskServiceDao.queryAllByLimit(param);
        return null;
    }
}
