package com.mmc.pms.model.sale.vo;

import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author LW
 * @date 2022/9/23 10:33
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GoodsProductSkuVO implements Serializable {
    private static final long serialVersionUID = -2681122778843398310L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "修改时id不能为空", groups = {Update.class})
    private Integer id;
    @NotNull(message = "产品名称不能为空", groups = {Update.class, Create.class})
    @ApiModelProperty(value = "产品名称")
    private String productName;
    @NotNull(message = "产品类型不能为空", groups = {Update.class, Create.class})
    @ApiModelProperty(value = "产品类型")
    private Integer goodsTypeId;
    @ApiModelProperty()
    private String categoryName;
    @ApiModelProperty(value = "型号")
    private String model;
    @ApiModelProperty(value = "产品品牌")
    private String productBrand;
    @ApiModelProperty(value = "品牌id")
    private Integer productBrandId;
    @ApiModelProperty(value = "目录id")
    private Integer directoryId;
}
