package com.mmc.pms.model.sale.vo;

import com.mmc.pms.model.sale.dto.ProductSpecVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @Author LW
 * @date 2023/5/29 9:58
 * 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class GoodsProdSpecVO implements Serializable {

    @ApiModelProperty(value = "id")
    private Integer id;

    @ApiModelProperty(value = "规格名称")
    private String goodsSpecName;

    @ApiModelProperty(value = "产品类型id")
    private Integer categoryId;


    @ApiModelProperty(value = "产品:自定义时此字段可不用填写")
    private Integer skuId;
    @ApiModelProperty(value = "规格来源  0:获取 1：自定义")
    private Integer flag;

    @ApiModelProperty(value = "产品名称（自定义的时候才需要传值）")
    private String productName;

    @ApiModelProperty(value = "选项来源")
    private List<MallProductSpecVO> specIds;

    @ApiModelProperty(value = "选择方式")
    private Integer chooseType;

    @ApiModelProperty(value = "规格单位")
    private Integer skuUnitId;

    @ApiModelProperty(value = "是否必选")
    private Integer must;

    @ApiModelProperty(value = "自定义规格的信息填充")
    private List<ProductSpecVO> customizeInfo;

    @ApiModelProperty(value = "删除的自定义规格id")
    private List<Integer> delProductSpecId;
}
