package com.mmc.pms.model.qo;

import com.mmc.pms.model.group.Freeze;
import com.mmc.pms.page.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @Author small @Date 2023/5/16 13:29 @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.mall.vo.GoodsInfoQO", description = "商品列表查询QO")
public class GoodsInfoQO {
  /*@ApiModelProperty(value = "商品名称")
  private String goodsName;

  @ApiModelProperty(value = "一级分类id")
  private Integer masterTypeId;

  @ApiModelProperty(value = "二级分类id")
  private Integer slaveTypeId;

  @ApiModelProperty(value = "开始时间")
  private String startTime;

  @ApiModelProperty(value = "结束时间")
  private String endTime;

  @ApiModelProperty(value = "状态 0:下架（仓库中）1:上架")
  private Integer status;*/

    @ApiModelProperty(name = "districtId", value = "地域id", example = "1", required = false)
    private Integer districtId;

    @ApiModelProperty(name = "产品类目id", value = "产品类目id", example = "1", required = false)
    private Integer productCategoryId;

    @ApiModelProperty(name = "brandId", value = "品牌id", example = "1", required = false)
    private Integer brandId;

    @ApiModelProperty(name = "partsId", value = "部件id", example = "1", required = false)
    private Integer partsId;

    @ApiModelProperty(name = "modelId", value = "型号id", example = "1", required = false)
    private Integer modelId;

    @ApiModelProperty(name = "qualityId", value = "成色id", example = "1", required = false)
    private Integer qualityId;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(
            message = "页码不能为空",
            groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(
            message = "每页显示数不能为空",
            groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
