package com.mmc.pms.entity;

import com.mmc.pms.model.categories.vo.DirectoryInfoVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 目录管理表(Directory)实体类
 *
 * @author makejava
 * @since 2023-05-24 14:58:31
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Directory implements Serializable {
    private static final long serialVersionUID = 713939370607409336L;
    /**
     * 主键id
     */
    private Integer id;
    /**
     * 目录名称
     */
    private String directoryName;
    /**
     * 其他目录关联id
     */
    private Integer pid;
    /**
     * 类型：（0：通用目录 1：作业服务目录 2：设备目录 3：飞手目录 4：商城目录）
     */
    private Integer type;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;
    /**
     * 是否删除
     */
    private Integer deleted;

    private String relevanceName;

    public Directory(DirectoryInfoVO param) {
        this.id = param.getId();
        this.directoryName = param.getDirectoryName();
        this.pid = param.getPid();
        this.type = param.getType();
    }

    public DirectoryInfoVO buildDirectoryInfoVO() {
        return DirectoryInfoVO.builder().id(id).directoryName(directoryName).pid(pid).relevanceName(relevanceName).type(type).build();
    }
}

