package com.mmc.pms.dao;

import com.mmc.pms.entity.Categories;
import com.mmc.pms.entity.Directory;
import com.mmc.pms.model.categories.vo.ClassifyInfoVO;
import com.mmc.pms.model.categories.vo.DirectoryInfoVO;
import com.mmc.pms.model.sale.vo.QueryClassifyVO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @author 23214
 * @description 针对表【categories(通用分类表)】的数据库操作Mapper
 * @createDate 2023-05-24 10:29:28
 * @Entity com.mmc.pms.entity.Categories
 */
@Mapper
public interface CategoriesDao {

    int countUpdateDirectoryName(DirectoryInfoVO param);

    void insertDirectory(Directory directory);

    void updateDirectory(Directory directory);

    int countDirectoryList();

    List<Directory> directoryList(int pageNo, Integer pageSize, Integer type);

    int countDirectory(Integer id);

    void removeDirectory(Integer id);

    int countClassificationByName(ClassifyInfoVO classifyInfoVO);

    int getCountCategoriesByPid(Integer pid, Integer type);

    void insertClassification(Categories categories);

    void updateClassification(ClassifyInfoVO classifyInfoVO);

    Categories getGoodsGroupById(Integer id);

    int updateTypeSort(Integer id, Integer sort);

    List<Categories> selectAllClassification(QueryClassifyVO queryClassifyVO);

    int countListClassification(QueryClassifyVO queryClassifyVO);

    int selectDirectoryById(Integer id);

    int deleteById(Integer id);

    List<Directory> getDirectoryList(Integer type);
}




