package com.mmc.pms.controller;


import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import com.mmc.pms.model.qo.ServiceQO;
import com.mmc.pms.model.work.vo.ServiceVO;
import com.mmc.pms.service.BackstageTaskService;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 * @date 2023/6/6 10:41
 * 概要：
 */
@Api(tags = {"后台-服务管理-模块"})
@RestController
@RequestMapping("/backstage/work")
public class BackstageTaskServiceController extends BaseController {
    @Resource
    private BackstageTaskService backstageTaskService;

    @ApiOperation(value = "新增作业服务")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("addWorkService")
    public ResultBody addWorkService(@Validated(Create.class) @RequestBody ServiceVO param, HttpServletRequest request) {
        return backstageTaskService.addWorkService(param, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "修改作业服务")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updateWorkService")
    public ResultBody updateWorkService(@Validated(Update.class) @RequestBody ServiceVO param) {
        return backstageTaskService.updateById(param);
    }

    @ApiOperation(value = "删除作业服务")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("deleteWorkService")
    public ResultBody deleteWorkService(@ApiParam("作业服务id") @RequestParam(value = "id") Integer id) {
        return backstageTaskService.deleteById(id);
    }

    @ApiOperation(value = "查询作业服务")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("queryWorkService")
    public ResultBody queryWorkService(@ApiParam("作业服务id") @RequestParam(value = "id") Integer id) {
        return backstageTaskService.queryById(id);
    }

    @ApiOperation(value = "查询工作服务列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("queryWorkServiceList")
    public ResultBody queryWorkServiceList(@Validated(Create.class) @RequestBody ServiceQO param, HttpServletRequest request) {
        return backstageTaskService.queryWorkServiceList(param, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }
}
