package com.mmc.pms.controller;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.categories.dto.ClassifyDetailsDTO;
import com.mmc.pms.model.categories.dto.ClassifyInfoDTO;
import com.mmc.pms.model.categories.vo.ClassifyInfoVO;
import com.mmc.pms.model.categories.vo.DirectoryInfoVO;
import com.mmc.pms.model.categories.vo.RelevantBusinessVO;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import com.mmc.pms.model.sale.vo.QueryClassifyVO;
import com.mmc.pms.service.CategoriesService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.Min;

/**
 * @Author lw @Date 2023/5/15 13:24 @Version 1.0
 */
@Api(tags = {"后台-分类管理-接口"})
@RestController
@RequestMapping("/classify")
public class BackstageCategoriesController {
    @Autowired
    private CategoriesService categoriesService;

    @ApiOperation(value = "新增or修改目录")
    @PostMapping("addOrEditDirectory")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addOrEditDirectory(@RequestBody DirectoryInfoVO param) {
        return categoriesService.addOrEditDirectory(param);
    }

    @ApiOperation(value = "目录列表")
    @GetMapping("directoryList")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = DirectoryInfoVO.class)})
    public ResultBody directoryList(@RequestParam Integer pageNo, @RequestParam Integer pageSize, @RequestParam(required = false) Integer type) {
        return ResultBody.success(categoriesService.directoryList(pageNo, pageSize, type));
    }

    @ApiOperation(value = "删除目录")
    @GetMapping("removeDirectory")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody removeDirectory(@ApiParam(value = "id") @RequestParam(value = "id") Integer id) {
        return categoriesService.removeDirectory(id);
    }

    @ApiOperation(value = "分类新增")
    @PostMapping("addClassification")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addClassification(@Validated(Create.class) @RequestBody ClassifyInfoVO classifyInfoVO) {
        return categoriesService.addClassification(classifyInfoVO);
    }


    @ApiOperation(value = "分类修改")
    @PostMapping("updateClassification")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody updateClassification(@Validated(Update.class) @RequestBody ClassifyInfoVO classifyInfoVO) {
        return categoriesService.updateClassification(classifyInfoVO);
    }

    @ApiOperation(value = "分类信息-排序")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("exchangeSortType")
    public ResultBody exchangeSortType(@ApiParam(value = "第一个分类id", required = true) @RequestParam(value = "firstId") Integer firstId,
                                       @ApiParam(value = "第二个分类id", required = true) @RequestParam(value = "secondId") Integer secondId) {
        return categoriesService.exchangeSortType(firstId, secondId);
    }


    @ApiOperation(value = "分类信息-列表")
    @PostMapping("getClassificationList")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ClassifyInfoDTO.class)})
    public ResultBody getClassificationList(@RequestBody QueryClassifyVO queryClassifyVO) {
        return ResultBody.success(categoriesService.getClassificationList(queryClassifyVO));
    }


    @ApiOperation(value = "分类详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ClassifyDetailsDTO.class)})
    @GetMapping("getClassifyDetails")
    public ResultBody getClassifyDetails(@ApiParam(value = "分类id", required = true) @RequestParam(value = "id") Integer id) {
        return categoriesService.getClassifyDetails(id);
    }

    @ApiOperation(value = "分类详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RelevantBusinessVO.class)})
    @GetMapping("queryRelevantBusiness")
    public ResultBody queryRelevantBusiness(@ApiParam(value = "分类id", required = true) @RequestParam(value = "id") Integer id,
                                            @ApiParam(value = "业务类型", required = true) @Min(value = 0) @RequestParam(value = "type") Integer type) {
        return categoriesService.queryRelevantBusiness(id, type);
    }

    @ApiOperation(value = "分类删除")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RelevantBusinessVO.class)})
    @GetMapping("deleteRelevantBusiness")
    public ResultBody deleteRelevantBusiness(@ApiParam(value = "分类id", required = true) @Min(value = 1) @RequestParam(value = "id") Integer id) {
        return categoriesService.deleteRelevantBusiness(id);
    }

    @ApiOperation(value = "目录列表不含分页")
    @GetMapping("getDirectoryList")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = DirectoryInfoVO.class)})
    public ResultBody getDirectoryList(Integer type) {
        return categoriesService.getDirectoryList(type);
    }

}
