package com.mmc.pms.model.qo;

import com.mmc.pms.common.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/6/6 20:41
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UserAccountQO implements Serializable {
    private static final long serialVersionUID = -6821428525057467450L;
    @ApiModelProperty(value = "关键字", required = false, example = "lux")
    private String keyword;

    @ApiModelProperty(value = "电话号码", required = false)
    private String phoneNum;

    @ApiModelProperty(value = "用户名", required = false, hidden = true)
    private String userName;

    @ApiModelProperty(value = "开始时间", example = "2023-05-18 00:00:00")
    private String startTime;

    @ApiModelProperty(value = "结束时间", example = "2023-10-18 23:59:59")
    private String endTime;

    @ApiModelProperty(value = "实名认证状态（0未通过，1通过）", hidden = true)
    private Integer realAuthStatus;

    @ApiModelProperty(value = "企业认证状态（0未通过，1通过）", example = "1")
    private Integer companyAuthStatus;

    @ApiModelProperty(value = "电子签章认证状态（0未通过，1通过）", hidden = true)
    private Integer entVerifyStatus;

    @ApiModelProperty(value = "用户来源：0自然流，1海报，2抖音，3公众号，4社群，5招投标，默认0", hidden = true)
    private Integer source;

    @ApiModelProperty(value = "用户id集合")
    private List<Integer> userIds;

    @ApiModelProperty(value = "页码", required = true, example = "1")
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true, example = "10")
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
