package com.mmc.pms.model.work.dto;

import com.mmc.pms.entity.InspComtDO;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class WorkServiceDTO implements Serializable {

    private static final long serialVersionUID = -15752785758L;

    private Integer id;

    @ApiModelProperty(value = "服务名称")
    private String serviceName;

    @ApiModelProperty(value = "服务价格")
    private BigDecimal servicePrice;

    @ApiModelProperty(value = "封面图")
    private String coverPlan;

    @ApiModelProperty(value = "分享卡片")
    private String shareCard;

    @ApiModelProperty(value = "视频")
    private String video;

    @ApiModelProperty(value = "服务介绍")
    private String serviceIntroduction;

    @ApiModelProperty(value = "部门名称")
    private String companyName;

    @ApiModelProperty(value = "部门id")
    private Integer companyId;

    @ApiModelProperty(value = "评论列表")
    private List<InspComtDO> inspComtList;

    @ApiModelProperty(value = "评论数量")
    private Integer inspComtAmount;
}
