package com.mmc.pms.dao;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.entity.ServiceDO;
import com.mmc.pms.model.qo.ServiceQO;
import com.mmc.pms.model.work.dto.ServiceDTO;
import com.mmc.pms.model.work.vo.UpAndDownServiceVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author LW
 *
 * @date 2023/6/6 10:48 概要：
 */
@Mapper
public interface BackstageTaskServiceDao {
  Integer insert(ServiceDO serviceDO);

  Integer update(ServiceDO serviceDO);

  Integer deleteByIds(@Param("ids") List<Integer> ids);

  ServiceDO queryById(Integer id);

  List<ServiceDO> queryAllByLimit(ServiceQO param);

  Integer count(ServiceQO param);

  int conditionCount(
      @Param("param") ServiceQO param,
      @Param("categoriesIds") List<Integer> categoriesIds,
      @Param("userIds") List<Integer> userIds);

  List<ServiceDO> queryPageByLimit(
      @Param("param") ServiceQO param,
      @Param("categoriesIds") List<Integer> categoriesIds,
      @Param("userIds") List<Integer> userIds);

  List<ServiceDTO> QueryWorkServiceListById(@Param("ids") List<Integer> ids);

  Integer batchUpAndDownWorkService(@Param("param") UpAndDownServiceVO param);

  Integer getWorkServiceCountByCategoriesId(@Param("categoriesIds") List<Integer> categoriesIds);

  Integer queryByIdCount(Integer companyId);

    void exchange(ServiceDO serviceDO);

  void exchangeSort(Integer id,Integer sort);
}
