package com.mmc.pms.service.category.impl;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.common.ResultEnum;
import com.mmc.pms.dao.category.CategoryDao;
import com.mmc.pms.entity.ServiceDO;
import com.mmc.pms.entity.category.CategoryPrimaryDO;
import com.mmc.pms.entity.category.CategorySubDO;
import com.mmc.pms.model.category.dto.CategoryPrimaryDTO;
import com.mmc.pms.model.category.dto.CategorySubDTO;
import com.mmc.pms.model.category.qo.CategoryQO;
import com.mmc.pms.model.category.vo.CategoryPrimaryVO;
import com.mmc.pms.model.category.vo.CategorySubVO;
import com.mmc.pms.page.PageResult;
import com.mmc.pms.service.category.CategoryService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/7/20 16:26
 * @Version 1.0
 */
@Service
public class CategoryServiceImpl implements CategoryService {


    @Autowired
    private CategoryDao categoryDao;

    @Override
    public ResultBody addPrimaryCategory(CategoryPrimaryVO primaryVO) {
        int count = categoryDao.getCountName(primaryVO.getName());
        if (count > 0) {
            return ResultBody.error(ResultEnum.THE_NAME_OF_A_CLASS_MUST_BE_UNIQUE);
        }
        CategoryPrimaryDO primaryDO = new CategoryPrimaryDO(primaryVO);
        categoryDao.addPrimaryCategory(primaryDO);
        Integer id = primaryDO.getId();
        categoryDao.updateSort(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody deletePrimaryCategory(Integer id) {
        Integer integer = categoryDao.selectPrimary(id);
        if (integer != 0) {
            return ResultBody.error(ResultEnum.THE_CURRENT_CATEGORY_IS_ASSOCIATED_WITH_GOODS);
        }
        categoryDao.deletePrimaryCategory(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody updatePrimaryCategory(CategoryPrimaryVO primaryVO) {
        CategoryPrimaryDO primaryDO = new CategoryPrimaryDO(primaryVO);
        Integer count = categoryDao.categoryCount(primaryDO);
        if (count > 0) {
            return ResultBody.error(ResultEnum.THE_NAME_OF_A_CLASS_MUST_BE_UNIQUE);
        }
        categoryDao.updatePrimaryCategory(primaryDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody addSubCategory(CategorySubVO subVO) {
        int count = categoryDao.getCountSubName(subVO.getName(), subVO.getCategoryPrimaryId());
        if (count > 0) {
            return ResultBody.error(ResultEnum.THE_NAME_OF_THE_SECONDARY_CLASS_MUST_BE_UNIQUE);
        }
        CategorySubDO subDO = new CategorySubDO(subVO);
        int number = (int) (Math.random() * 90 + 10);
        subDO.setId(subVO.getCategoryPrimaryId() + 1 + number);
        categoryDao.addSubCategory(subDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateSubCategory(CategorySubVO subVO) {
        CategorySubDO subDO = new CategorySubDO(subVO);
        Integer count = categoryDao.categorySubCount(subDO);
        if (count > 0) {
            return ResultBody.error(ResultEnum.THE_NAME_OF_THE_SECONDARY_CLASS_MUST_BE_UNIQUE);
        }
        categoryDao.updateSubCategory(subDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody deleteSubCategory(Integer id) {
        Integer integer = categoryDao.selectSubMallGoods(id);
        if (integer != 0) {
            return ResultBody.error(ResultEnum.THE_CURRENT_CATEGORY_IS_ASSOCIATED_WITH_GOODS);
        }
        categoryDao.deleteSubCategory(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody<CategorySubDTO> detailSubCategory(Integer id) {
        CategorySubDO subDO = categoryDao.detailSubCategory(id);
        CategorySubDTO categorySubDTO = null;
        if (subDO != null) {
            categorySubDTO = subDO.buildCategorySubDTO();
        }
        return ResultBody.success(categorySubDTO);
    }

    @Override
    public PageResult<CategoryPrimaryDTO> categoryList(CategoryQO param) {
        int count = categoryDao.categoryListCount(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        param.buildCurrentPage();
        List<CategoryPrimaryDO> categoryPrimaryDOS = categoryDao.categoryList(param);
        List<CategoryPrimaryDTO> collect = categoryPrimaryDOS.stream().map(t -> t.buildCategoryPrimaryDTO()).collect(Collectors.toList());
        return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count, collect);
    }


    @Transactional
    @Override
    public ResultBody exchange(List<CategoryPrimaryVO> list) {
        Integer sort = list.get(0).getSort();
        ServiceDO serviceDO = new ServiceDO();
        serviceDO.setId(list.get(0).getId());
        serviceDO.setSort(list.get(1).getSort());
        categoryDao.exchange(serviceDO);

        ServiceDO serviceDO1 = new ServiceDO();
        serviceDO1.setId(list.get(1).getId());
        serviceDO1.setSort(sort);
        categoryDao.exchange(serviceDO1);
        return ResultBody.success();

    }

    @Override
    public ResultBody<CategoryPrimaryDTO> appCategoryInfo() {
        // 获取所有以及分类
        List<CategoryPrimaryDO> categoryPrimaryList = categoryDao.selectPrimaryList();
        if (CollectionUtils.isEmpty(categoryPrimaryList)) {
            return ResultBody.success();
        }
        List<CategoryPrimaryDTO> primaryList = categoryPrimaryList.stream()
                .map(CategoryPrimaryDO::buildCategoryPrimaryDTO).collect(Collectors.toList());
        List<Integer> ids = primaryList.stream().map(CategoryPrimaryDTO::getId).collect(Collectors.toList());
        // 批量查找二级分类
        List<CategorySubDO> categorySubList = categoryDao.selectCategorySubList(ids);
        if (CollectionUtils.isNotEmpty(categorySubList)) {
            Map<Integer, List<CategorySubDO>> subMap = categorySubList.stream().collect(Collectors.groupingBy(CategorySubDO::getCategoryPrimaryId));
            for (CategoryPrimaryDTO categoryPrimaryDTO : primaryList) {
                List<CategorySubDO> categorySubDOList = subMap.get(categoryPrimaryDTO.getId());
                categoryPrimaryDTO.setSubDTOList(categorySubDOList);
            }
        }
        return ResultBody.success(primaryList);
    }
}
