package com.mmc.pms.model.sale.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @Author small @Date 2023/5/16 15:03 @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Accessors(chain = true)
public class GoodsSpecDTO implements Serializable {
    private static final long serialVersionUID = -8681372139970849591L;

    @ApiModelProperty(value = "id")
    private Integer id;

    @ApiModelProperty(value = "规格名称")
    private String goodsSpecName;

    @ApiModelProperty(value = "产品或行业skuId")
    private Integer skuId;

    @ApiModelProperty(value = "品牌id")
    private Integer brandInfoId;

    @ApiModelProperty(value = "产品或行业sku名称")
    private String skuName;

    @ApiModelProperty(value = "产品规格信息")
    private List<MallProductSpecDTO> productSpecList;

    @ApiModelProperty(value = "行业规格信息")
    private List<MallIndustrySpecDTO> industrySpecList;

    @ApiModelProperty(value = "选择方式")
    private Integer chooseType;

    @ApiModelProperty(value = "规格单位")
    private Integer skuUnitId;

    @ApiModelProperty(value = "单位名称")
    private String unitName;

    @ApiModelProperty(value = "是否必选")
    private Integer must;

    @ApiModelProperty(value = "规格来源 0获取 1自定义")
    private Integer flag;
}
