package com.mmc.pms.model.category.dto;

import com.mmc.pms.entity.category.CategorySubDO;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;
import java.util.List;

/**
 * @Author small
 * @Date 2023/7/20 16:35
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CategoryPrimaryDTO {

    @ApiModelProperty(value = "id")
    @NotNull(message = "id不能为空", groups = {Update.class})
    @Min(value = 1, groups = {Update.class})
    private Integer id;

    @ApiModelProperty(value = "分类名称", required = true, example = "无人机")
    @Size(max = 15, message = "分类名称不能超过15个字", groups = {Update.class, Create.class})
    @NotBlank(message = "分类名称不能为空或空字符", groups = {Update.class, Create.class})
    private String name;

    @ApiModelProperty(value = "描述")
    @Size(max = 70, message = "分类描述不能超过70个字", groups = {Update.class, Create.class})
    private String description;

    @ApiModelProperty(value = "icon图标")
    private String icon;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间", example = "2023-07-14 10:13:12", required = true)
    private Date createTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新时间", example = "2023-07-14 10:13:12", required = true)
    private Date updateTime;

    @ApiModelProperty(value = "二级分类")
    private List<CategorySubDO> subDTOList;

    @ApiModelProperty(value = "顺序")
    private Integer sort;

}
