package com.mmc.pms.model.categories.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Author LW
 * @date 2022/3/22 15:50
 * 概要：一级分类信息DTO
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ClassifyDetailsDTO implements Serializable {
    private static final long serialVersionUID = -1682216002629752311L;
    @ApiModelProperty(value = "分类id")
    private Integer id;

    @ApiModelProperty(value = "分类名称")
    private String classifyName;


    @ApiModelProperty(value = "描述")
    private String description;

    @ApiModelProperty(value = "icon图标")
    private String icon;

    @ApiModelProperty(value = "小程序底部备注")
    private String remark;
}
