package com.mmc.pms.entity.mall;

import com.mmc.pms.model.mall.GoodsResourcesVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * (MallGoodsResourcesDO)实体类
 *
 * @author makejava
 * @since 2023-07-24 21:13:15
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MallGoodsResourcesDO implements Serializable {
    private static final long serialVersionUID = -98370711703270379L;

    private Integer id;

    private Integer mallGoodsId;
    /**
     * 资源url
     */
    private String url;
    /**
     * 类型：0主图 1副图 2视频
     */
    private Integer type;

    private Date createTime;

    private Date updateTime;

    public MallGoodsResourcesDO(GoodsResourcesVO d) {
        this.type = d.getType();
        this.id = d.getId();
        this.url = d.getUrl();
    }

    public GoodsResourcesVO buildGoodsResourcesVO() {
        return GoodsResourcesVO.builder().id(id).url(url).type(type).build();
    }
}

