package com.mmc.pms.dao;

import com.mmc.pms.entity.*;
import com.mmc.pms.model.lease.vo.PriceAcquisition;
import com.mmc.pms.model.order.dto.OrderGoodsProdDTO;
import com.mmc.pms.model.qo.MallOrderGoodsInfoQO;
import com.mmc.pms.model.qo.ProductSkuQO;
import com.mmc.pms.model.sale.dto.ProductSkuVO;
import com.mmc.pms.model.sale.dto.ProductSpecPriceDTO;
import com.mmc.pms.model.sale.dto.ProductSpecVO;
import com.mmc.pms.model.sale.vo.ProductSpecCPQVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * @author 23214
 * @description 针对表【product_sku(产品sku表)】的数据库操作Mapper
 * @createDate 2023-05-25 14:55:56 @Entity com.mmc.pms.entity.ProductSku
 */
@Mapper
public interface ProductDao {

  int countSkuName(ProductSkuVO param);

  int insertProductSku(ProductDO productDO);

  int countProductIsExist(Integer id);

  ProductDO getProductDetail(Integer id);

  int updateProductSku(ProductDO productDO);

  int countListPageProductSku(ProductSkuQO productSkuQO);

  List<ProductDO> listPageProductSku(ProductSkuQO productSkuQO);

  int countSpecName(ProductSpecVO param);

  int insertProductSpec(ProductSpecDO productSpecDO);

  int updateProductSpec(ProductSpecDO productSpecDO);

  int countSpecIsExist(Integer id);

  ProductSpecDO getProductSpecDetail(Integer id);

  int countListPageProductSpec(@Param("id") Integer id, @Param("keyword") String keyword);

  List<ProductSpecDO> listPageProductSpec(
      @Param(value = "pageNo") Integer pageNo,
      @Param(value = "pageSize") Integer pageSize,
      @Param(value = "productId") Integer productId,
      @Param(value = "keyword") String keyword);

  int batchInsertSpecPrice(List<ProductSpecPriceDO> list);

  void batchInsertLeaseSpecPrice(List<ProductSpecPriceDO> list);

  void removeProductSpecCPQ(ProductSpecCPQVO productSpecCPQVO);

  List<ProductSpecPriceDO> getProductSpecPrice(ProductSpecCPQVO productSpecCPQVO);

  void insertMallProdSkuInfo(MallProdInfoDO mallProdInfoDO);

  List<ProductSpecDO> listProductSpec(Integer id);

  List<ProductDO> listProductSkuDO(List<Integer> productId);

  List<InventorySpecDO> listInventorySpecInfo(List<Integer> industryProductInventoryIds);

  List<ProductSpecDO> listProductSpecInfo(List<Integer> productSpecIds);

  void batchUpdateMallProdSpec(List<Integer> delProductSpecId);

  int countProductSpecByBrandId(Integer id);

  void removeProductSku(Integer id);

  void removeProductSpec(Integer id);

  List<IndustrySpecDO> listIndustrySpec(@Param("industrySpecIds") Set<Integer> industrySpecIds);

  List<InventorySpecDO> listInventorySpec(Integer id);

  List<BigDecimal> feignGetUnitPriceByTag(PriceAcquisition priceAcquisition);

  List<MallGoodsSpecInfoDO> listProdSpecInfo(@Param("prodIds") Set<Integer> prodIds);

  /**
   * 根据渠道等级、商品specId获取price信息
   *
   * @param tagInfoId
   * @param prodSkuSpecIds
   * @return
   */
  List<ProductSpecPriceDO> listProductSpecPrice(Integer tagInfoId, Set<Integer> prodSkuSpecIds);

  ProductSpecPriceDTO feignGetUnitPrice(Integer id, Integer tagId);

  List<ProductSpecDO> getProductSpecList(List<Integer> productIds);

  List<MallProdSkuInfoSpecDO> getProductSpecByIds(List<Integer> delProductSpecId);

  Set<Integer> listProductSpecIds(@Param("mallProdSkuSpecIds") Set<Integer> mallProdSkuSpecIds);

  List<OrderGoodsProdDTO> listProdGoodsSkuInfo(MallOrderGoodsInfoQO mallOrderGoodsInfoQO);

  List<MallProdSkuInfoSpecDO> listMallProductSpec(Integer id);

  List<ProductSpecPriceDO> getProductSpecPriceList(List<Integer> specIds);

  ProductSpecPriceDO getProductSpecPriceById(Integer id);

  List<DirectoryDO> productDirectoryList();

  List<ProductSpecPriceDO> listAllProductSpecPriceByType(
      @Param("prodSkuSpecIds") Set<Integer> prodSkuSpecIds);

  int countSpecByProdSkuId(Integer id);

  BigDecimal getMarketplacePrice(PriceAcquisition priceAcquisition);
}
