package com.mmc.pms.controller;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.model.group.Create;
import com.mmc.pms.model.group.Update;
import com.mmc.pms.model.order.dto.OrderGoodsIndstDTO;
import com.mmc.pms.model.order.dto.OrderGoodsProdDTO;
import com.mmc.pms.model.qo.MallOrderGoodsInfoQO;
import com.mmc.pms.model.qo.ProductSpecPriceQO;
import com.mmc.pms.model.sale.dto.*;
import com.mmc.pms.model.sale.qo.MallGoodsQO;
import com.mmc.pms.model.sale.vo.BatchShelfVO;
import com.mmc.pms.model.sale.vo.GoodsAddVO;
import com.mmc.pms.service.GoodsInfoService;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @Author LW
 * @date 2023/3/14 13:22 概要：
 */
@RestController
@RequestMapping("/goods")
@Api(tags = {"后台-商品管理-相关接口"})
public class BackstageGoodsManageController extends BaseController {
    @Resource
    private GoodsInfoService goodsInfoService;

    @ApiOperation(value = "新增(租赁/销售)商品")
    @PostMapping("addGoodsInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody addGoods(
            @ApiParam("商品信息VO") @Validated(Create.class) @RequestBody GoodsAddVO goodsAddVO,
            HttpServletRequest request) {
        return goodsInfoService.addGoods(
                goodsAddVO, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "修改(租赁/销售)商品")
    @PostMapping("editGoodsInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public ResultBody editGoodsInfo(
            @ApiParam("商品信息VO") @Validated(Update.class) @RequestBody GoodsAddVO goodsAddVO) {
        return goodsInfoService.editGoodsInfo(goodsAddVO);
    }

    @ApiOperation(value = "PC端-商品详情")
    @GetMapping("getGoodsInfoDetail")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallGoodsDetailDTO.class)})
    public ResultBody getGoodsInfoDetail(
            @ApiParam("商品id") @RequestParam Integer goodsInfoId,
            @RequestParam Integer type,
            @RequestParam(required = false) @ApiParam("租赁时限：（输入0：1-7天、输入1：8-15天、输入2：16-30天、输入3：30天以上）")
                    Integer leaseTerm) {
        return goodsInfoService.getGoodsInfoDetail(goodsInfoId, type, leaseTerm);
    }

    @ApiOperation(value = "商品列表-分页")
    @PostMapping("listPageGoodsInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = GoodsInfoListDTO.class)})
    public ResultBody listPageGoodsInfo(@ApiParam("商品查询条件QO") @RequestBody MallGoodsQO param) {
        return ResultBody.success(goodsInfoService.listPageGoodsInfo(param));
    }

    @ApiOperation(value = "商品批量上下架")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("batchOnShelfOrTakeDown")
    public ResultBody batchOnShelfOrTakeDown(
            @ApiParam(value = "商品上下架参数", required = true) @RequestBody BatchShelfVO batchOnShelfVO) {
        return goodsInfoService.batchOnShelfOrTakeDown(
                batchOnShelfVO.getGoodsIds(), batchOnShelfVO.getStatus());
    }

    @ApiOperation(value = "商品批量删除")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("batchRemoveWareInfo")
    public ResultBody batchRemoveWareInfo(
            @ApiParam(value = "商品id数组", required = true) @RequestBody List<Integer> ids) {
        return goodsInfoService.batchRemoveWareInfo(ids);
    }

    @ApiOperation(value = "单位信息")
    @GetMapping("getSkuUnit")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = SkuUnitDTO.class)})
    public ResultBody getSkuUnit() {
        return goodsInfoService.getSkuUnit();
    }

    @ApiOperation(value = "PC端-其他服务-列表")
    @GetMapping("listOtherService")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = SaleServiceDTO.class)})
    public ResultBody listOtherService() {
        return goodsInfoService.getSaleServiceInfoToList();
    }

    @ApiOperation(value = "feign根据购物车信息填充未知信息", hidden = true)
    @PostMapping("fillGoodsInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallGoodsShopCarDTO.class)})
    public List<MallGoodsShopCarDTO> fillGoodsInfo(@RequestBody List<MallGoodsShopCarDTO> param) {
        return goodsInfoService.fillGoodsInfo(param);
    }

    @ApiOperation(value = "feign根据渠道等级和产品规格id获取对应价格", hidden = true)
    @PostMapping("feignListProductSpecPrice")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    public List<MallProductSpecPriceDTO> feignListProductSpecPrice(
            @RequestBody ProductSpecPriceQO productSpecPriceQO) {
        return goodsInfoService.feignListProductSpecPrice(productSpecPriceQO);
    }

    @ApiOperation(value = "feign根据渠道等级获取单价信息", hidden = true)
    @GetMapping("feignGetUnitPriceByTag")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ProductSpecPriceDTO.class)})
    public ProductSpecPriceDTO feignGetUnitPriceByTag(
            @RequestParam(value = "specId") Integer specId,
            @RequestParam(value = "tagId") Integer tagId) {
        return goodsInfoService.feignGetUnitPriceByTag(specId, tagId);
    }

    @ApiOperation(value = "feign根据商品的产品规格id查询商品信息", hidden = true)
    @PostMapping("feignListProdGoodsSkuInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = OrderGoodsProdDTO.class)})
    public List<OrderGoodsProdDTO> feignListProdGoodsSkuInfo(
            @RequestBody MallOrderGoodsInfoQO mallOrderGoodsInfoQO) {
        return goodsInfoService.feignListProdGoodsSkuInfo(mallOrderGoodsInfoQO);
    }

    @ApiOperation(value = "feign根据商品的行业规格id查询商品清单信息", hidden = true)
    @PostMapping("feignListIndstGoodsSkuInfo")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = OrderGoodsProdDTO.class)})
    public List<OrderGoodsIndstDTO> feignListIndstGoodsSkuInfo(
            @RequestBody MallOrderGoodsInfoQO mallOrderGoodsInfoQO) {
        return goodsInfoService.feignListIndstGoodsSkuInfo(mallOrderGoodsInfoQO);
    }

    @ApiOperation(value = "商品列表-排序")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("exchangeGoodsInfo")
    public ResultBody exchangeGoodsInfo(@ApiParam(value = "第一个参数id", required = true) @RequestParam(value = "firstId") Integer firstId,
                                        @ApiParam(value = "第二个参数id", required = true) @RequestParam(value = "secondId") Integer secondId) {
        return goodsInfoService.exchangeGoodsInfo(firstId, secondId);
    }
}
