package com.mmc.pms.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author small @Date 2023/5/16 15:30 @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Accessors
public class ProductSpecDTO implements Serializable {
  private static final long serialVersionUID = -2681122778843398310L;

  @ApiModelProperty(value = "id")
  private Integer id;

  @ApiModelProperty(value = "productSkuId")
  private Integer productSkuId;

  @ApiModelProperty(value = "规格名称")
  private String specName;

  @ApiModelProperty(value = "规格图片")
  private String specImage;

  @ApiModelProperty(value = "料号")
  private String partNo;

  @ApiModelProperty(value = "版本描述")
  private String versionDesc;

  @ApiModelProperty(value = "创建时间")
  private Date createTime;

  @ApiModelProperty(value = "价格配置")
  private List<ProductSpecPriceDTO> priceList;
}
