package com.mmc.pms.entity;

import com.mmc.pms.model.dto.GoodsProductSkuDTO;
import com.mmc.pms.model.dto.GoodsProductSkuVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author small @Date 2023/5/16 16:29 @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class ProductSkuDO implements Serializable {
  private static final long serialVersionUID = -2830786012593215477L;
  private Integer id;
  private String productName;
  private Integer goodsTypeId;
  private String model;
  private String productBrand;
  private Date createTime;
  private Date updateTime;
  private Integer brandInfoId;
  private Integer deleted;
  private Integer sortTypeId;
  private Integer customize;

  /** 辅助字段 begin */
  private String typeName;

  private String sortName;

  /** 辅助字段 end */
  public ProductSkuDO(GoodsProductSkuVO param) {
    this.id = param.getId();
    this.goodsTypeId = param.getGoodsTypeId();
    this.model = param.getModel();
    this.productName = param.getProductName();
    this.brandInfoId = param.getProductBrandId();
    this.sortTypeId = param.getDirectoryId();
  }

  public GoodsProductSkuDTO buildGoodsProductSkuDTO() {
    return GoodsProductSkuDTO.builder()
        .id(this.id)
        .productName(this.productName)
        .goodsTypeId(this.goodsTypeId)
        .model(this.model)
        .productBrand(this.productBrand)
        .productBrandId(brandInfoId)
        .createTime(this.createTime)
        .typeName(this.typeName)
        .directoryId(sortTypeId)
        .directoryName(this.sortName)
        .build();
  }
}
