package com.mmc.pms.entity;

import com.mmc.pms.model.dto.DistrictInfoDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/5/15 14:33
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DistrictDO implements Serializable {
    private static final long serialVersionUID = 4345895963086642848L;
    private Integer id;
    private String name;
    private Integer level;
    private Integer pid;
    private List<DistrictDO> childInfo;

    public DistrictInfoDTO builderDistrictInfoDTO(){
        return DistrictInfoDTO.builder()
                .id(this.id)
                .name(this.name)
                .level(this.level)
                .pid(this.pid)
                .childInfo(CollectionUtils.isEmpty(this.childInfo)?null:this.childInfo.stream().map(d->{return d.builderDistrictInfoDTO();}).collect(Collectors.toList()))
                .build();
    }

}
