package com.mmc.pms.model.qo;

import com.mmc.pms.common.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @Author small @Date 2023/5/16 9:55 @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
// @ApiModel(value = "com.mmc.csf.model.qo.WareInfoQO", description = "model")
public class WareInfoQO implements Serializable {
    private static final long serialVersionUID = -2953141525621912414L;

    @ApiModelProperty(name = "districtId", value = "地域id", example = "1", required = false)
    private Integer provinceId;

    @ApiModelProperty(name = "categoryId", value = "分类id")
    private List<Integer> categoryId;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
