package com.mmc.pms.model.lease.dto;

import com.mmc.pms.model.sale.dto.GoodsDetailInfoDTO;
import com.mmc.pms.model.sale.dto.GoodsImgDTO;
import com.mmc.pms.model.sale.dto.GoodsOtherServiceDTO;
import com.mmc.pms.model.sale.dto.GoodsSpecDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @Author LW
 *
 * @date 2022/11/8 15:57 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class LeaseGoodsDetailDTO implements Serializable {
  @ApiModelProperty(value = "id")
  private Integer id;

  @ApiModelProperty(value = "pid")
  private Integer pid;

  @ApiModelProperty(value = "商品名称")
  private String goodsName;

  @ApiModelProperty(value = "云享飞服务id")
  private Integer shareFlyServiceId;

  @ApiModelProperty(value = "云仓配件id")
  private Integer repoId;

  @ApiModelProperty(value = "规格信息")
  private List<GoodsSpecDTO> goodsSpec;

  @ApiModelProperty(value = "商品图片")
  private List<GoodsImgDTO> images;

  @ApiModelProperty(value = "商品视频")
  private String goodsVideo;

  @ApiModelProperty(value = "商品视频id")
  private Integer goodsVideoId;

  @ApiModelProperty(value = "商品详情")
  private GoodsDetailInfoDTO goodsDetail;

  @ApiModelProperty(value = "所属目录")
  private Integer sortTypeId;

  @ApiModelProperty(value = "一级分类id")
  private Integer categoryByOne;

  @ApiModelProperty(value = "二级分类id")
  private Integer categoryByTwo;

  @ApiModelProperty(value = "商品标签")
  private String tag;

  @ApiModelProperty(value = "其他服务: 1:免费配送，2：专业飞手培训2日， 3：半年保修， 4：一年保修 ")
  private List<GoodsOtherServiceDTO> otherService;
}
