package com.mmc.pms.feign;

import com.mmc.pms.auth.dto.BUserAccountQO;
import com.mmc.pms.auth.dto.UserAccountSimpleDTO;
import com.mmc.pms.feign.hystrix.UserAppApiHystrix;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/18 17:06
 */
//@FeignClient(name = "cms-svc", fallback = UserAppApiHystrix.class)
@FeignClient(url = "${iuav.userapp.url}", name = "cms-svc", fallback = UserAppApiHystrix.class)
public interface UserAppApi {
    /**
     * 根据用户id获取基本信息
     *
     * @param userAccountId
     * @return
     */
    @RequestMapping(value = "/userapp/user-account/feignGetUserSimpleInfo", method = RequestMethod.GET)
    public UserAccountSimpleDTO feignGetUserSimpleInfo(@RequestParam Integer userAccountId, @RequestHeader("token") String token);

    /**
     * 根据地区信息查询用户id
     *
     * @param provinceCode
     * @param cityCode
     * @param districtCode
     * @return
     */
    @GetMapping("/userapp/user-account/feignListUserAccountIds")
    List<Integer> feignListUserAccountIds(@RequestParam Integer provinceCode, @RequestParam(required = false) Integer cityCode,
                                          @RequestParam(required = false) Integer districtCode, @RequestHeader(value = "token", required = false) String token);


    /**
     * 获取用户集合列表页面
     *
     * @param bUserAccountQO 问:b用户帐户
     * @return {@link List}<{@link UserAccountSimpleDTO}>
     */
    @PostMapping("/userapp/back-user/feignListBAccountPage")
    List<UserAccountSimpleDTO> feignListBAccountPage(@ApiParam(value = "账号查询QO", required = true) @RequestBody BUserAccountQO bUserAccountQO, @RequestHeader("token") String token);
}
