package com.mmc.pms.controller.common;

import com.mmc.pms.common.Page;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.constant.TokenConstant;
import com.mmc.pms.controller.BaseController;
import com.mmc.pms.model.lease.dto.LeaseGoodsInfoDTO;
import com.mmc.pms.model.qo.WareInfoQO;
import com.mmc.pms.service.WebDeviceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 *
 * @date 2023/6/8 17:16 概要：
 */
@Api(tags = {"v1.0.1-设备租赁-相关接口"})
@RestController
@RequestMapping("/lease/goods")
public class LeaseGoodsController extends BaseController {
  @Autowired private WebDeviceService webDeviceService;

  @ApiOperation(value = "设备列表筛选")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseGoodsInfoDTO.class)})
  @PostMapping("/deviceList")
  public ResultBody listWareInfoPage(
      @RequestBody @Validated(Page.class) WareInfoQO param, HttpServletRequest request) {
    if (request.getHeader(TokenConstant.TOKEN) == null) {
      return webDeviceService.listWareInfoPage(param, null, null);
    }
    return webDeviceService.listWareInfoPage(
        param, request, this.getUserLoginInfoFromRedis(request).getUserAccountId());
  }
}
