package com.mmc.pms.service;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.entity.ProductSpecPriceDO;
import com.mmc.pms.model.lease.vo.PriceAcquisition;
import com.mmc.pms.model.qo.ProductSkuQO;
import com.mmc.pms.model.sale.dto.ProductSkuVO;
import com.mmc.pms.model.sale.dto.ProductSpecVO;
import com.mmc.pms.model.sale.vo.ProductSpecCPQVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author 23214
 * @description 针对表【product_sku(产品sku表)】的数据库操作Service
 * @createDate 2023-05-25 14:55:56
 */
public interface ProductSkuService {

    ResultBody addProductSku(ProductSkuVO param);

    ResultBody getProductSkuDetail(Integer id);

    ResultBody editProductSku(ProductSkuVO param);

    ResultBody listPageProductSku(ProductSkuQO productSkuQO);

    ResultBody addOrEditProductSpec(ProductSpecVO param);

    ResultBody getProductSpecDetail(Integer id);

    ResultBody listPageProductSpec(Integer pageNo, Integer pageSize, Integer productSkuId);

    ResultBody productSpecCPQ(ProductSpecCPQVO productSpecCPQVO);

    List<ProductSpecPriceDO> getProductSpecPriceDOS(ProductSpecCPQVO productSpecCPQVO);

    ResultBody updateProductSpecCPQ(ProductSpecCPQVO productSpecCPQVO);

    ResultBody getProductSpecCPQ(ProductSpecCPQVO productSpecCPQVO);

    ResultBody removeProductSku(Integer id);

    ResultBody removeProductSpec(Integer id);

    BigDecimal feignGetUnitPriceByTag(PriceAcquisition priceAcquisition);

}
