package com.mmc.pms.model.qo;


import com.mmc.pms.common.Page;
import com.mmc.pms.model.group.Freeze;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author LW
 * @date 2023/6/8 10:33
 * 概要：
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ServiceQO implements Serializable {

    private static final long serialVersionUID = 1L;
    
    private Integer id;

    @ApiModelProperty(value = "服务名称", example = "服务名称")
    @Length(message = "最大不超过30字", max = 30)
    private String serviceName;

    @ApiModelProperty(value = "应用", example = "1")
    private Integer applicationId;

    @ApiModelProperty(value = "行业", example = "2")
    private Integer industryId;

    @ApiModelProperty(value = "账号id")
    private Integer accountId;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = {Page.class, Freeze.class})
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
