package com.mmc.pms.controller;

import com.mmc.pms.common.ResultBody;
import com.mmc.pms.common.ResultEnum;
import com.mmc.pms.model.lease.dto.BrandDTO;
import com.mmc.pms.model.lease.dto.DeviceCategoryDTO;
import com.mmc.pms.model.lease.dto.WareInfoDTO;
import com.mmc.pms.model.lease.dto.WareInfoItemDTO;
import com.mmc.pms.model.lease.vo.LeaseVo;
import com.mmc.pms.model.other.dto.AdDTO;
import com.mmc.pms.model.other.dto.DistrictInfoDTO;
import com.mmc.pms.model.other.dto.ModelDTO;
import com.mmc.pms.model.qo.WareInfoQO;
import com.mmc.pms.page.Page;
import com.mmc.pms.service.WebDeviceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @Author small @Date 2023/5/15 13:25 @Version 1.0
 */
@Api(tags = {"web设备租赁-接口"})
@RestController
@RequestMapping("/webDevice")
public class WebDeviceController {

    @Autowired
    private WebDeviceService webDeviceService;

    @ApiOperation(value = "地域")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/getSecondDistrictInfo")
    public ResultBody<DistrictInfoDTO> getSecondDistrictInfo() {
        return webDeviceService.listSecondDistrict();
    }

    @ApiOperation("设备类目")
    @GetMapping("/category")
    public ResultBody<DeviceCategoryDTO> category() {
        return webDeviceService.category();
    }

    @ApiOperation("品牌")
    @GetMapping("/brand")
    public ResultBody<BrandDTO> brand() {
        return webDeviceService.brand();
    }

    @ApiOperation("型号")
    @GetMapping("/model")
    public ResultBody<ModelDTO> model() {
        return webDeviceService.model();
    }

    @ApiOperation("设备品牌")
    @GetMapping("/deviceBrand")
    public ResultBody<BrandDTO> deviceBrand() {
        return webDeviceService.deviceBrand();
    }

    @ApiOperation("设备型号")
    @GetMapping("/deviceModel")
    public ResultBody<ModelDTO> deviceModel() {
        return webDeviceService.deviceModel();
    }

    @ApiOperation(value = "设备详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/detail")
    public ResultBody<WareInfoDTO> detail(@RequestParam(value = "id", required = true) Integer id) {
        WareInfoDTO wareInfoDTO = webDeviceService.getWareInfoById(id);
        return wareInfoDTO == null
                ? ResultBody.error(ResultEnum.NOT_FOUND)
                : ResultBody.success(wareInfoDTO);
    }

    @ApiOperation(value = "立即租赁")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/update")
    public ResultBody update(@RequestBody LeaseVo param) {
        return webDeviceService.update(param);
    }

    @ApiOperation("设备广告位")
    @GetMapping("/ad")
    public ResultBody<AdDTO> ad() {
        return webDeviceService.ad();
    }

    @ApiOperation(value = "设备列表筛选")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = WareInfoItemDTO.class)})
    @PostMapping("/deviceList")
    public ResultBody<WareInfoItemDTO> listWareInfoPage(
            @RequestBody @Validated(Page.class) WareInfoQO param) {
        return webDeviceService.listWareInfoPage(param);
    }

}
