package com.mmc.pms.controller;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.common.ResultEnum;
import com.mmc.pms.util.FileLoadUtil;
import com.mmc.pms.util.OssConstant;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Author small @Date 2023/5/23 10:12 @Version 1.0
 */
@Api(tags = {"上传文件"})
@RestController
@RequestMapping("/upload")
public class UploadController {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd/");

    @ApiOperation(value = "V1.0.1-上传一个图片或者文件到阿里云oss")
    @ApiImplicitParams({
            @ApiImplicitParam(
                    paramType = "header",
                    name = "mmc-identity",
                    dataTypeClass = java.lang.String.class,
                    dataType = "String",
                    required = false,
                    value = "token"),
            @ApiImplicitParam(
                    name = "uploadFile",
                    dataType = "MultipartFile",
                    dataTypeClass = org.springframework.web.multipart.MultipartFile.class,
                    required = true,
                    value = "文件/图片/后缀无限制"),
    })
    @PostMapping("/oss")
    public ResultBody oss(
            @RequestParam("uploadFile") MultipartFile uploadFile, HttpServletRequest request) {
        OSS ossClient =
                new OSSClientBuilder()
                        .build(OssConstant.ENDPOINT, OssConstant.ACCESSKEYID, OssConstant.ACCESSKEYSECRET);
        InputStream inputStream = null;
        try {
            inputStream = uploadFile.getInputStream();
        } catch (IOException e) {

            return ResultBody.error(e.getMessage());
        }
        String oldName = uploadFile.getOriginalFilename();
        String newName =
                "file/"
                        + UUID.randomUUID().toString()
                        + oldName.substring(oldName.lastIndexOf("."), oldName.length());
        ossClient.putObject(OssConstant.BUCKET, newName, inputStream);
        ossClient.shutdown();
        String filePath = "https://" + OssConstant.BUCKET + '.' + OssConstant.ENDPOINT + "/" + newName;
        JSONObject jsObj = new JSONObject();
        jsObj.put("filePath", filePath);
        return ResultBody.success(jsObj);
    }

    @ApiOperation(value = "V1.0.1-上传多个文件到阿里云oss")
    @ApiImplicitParams({
            @ApiImplicitParam(
                    paramType = "header",
                    name = "mmc-identity",
                    dataTypeClass = java.lang.String.class,
                    dataType = "String",
                    required = false,
                    value = "token"),
            @ApiImplicitParam(
                    name = "uploadFile",
                    dataType = "MultipartFile",
                    dataTypeClass = org.springframework.web.multipart.MultipartFile.class,
                    required = true,
                    value = "文件/图片"),
    })
    @PostMapping("/osses")
    public ResultBody osses(
            @RequestParam("uploadFile") MultipartFile[] uploadFile, HttpServletRequest request)
            throws IOException {
        OSS ossClient =
                new OSSClientBuilder()
                        .build(OssConstant.ENDPOINT, OssConstant.ACCESSKEYID, OssConstant.ACCESSKEYSECRET);
        List list = new LinkedList();
        if (uploadFile != null && uploadFile.length > 0) {
            System.out.println("osses文件数量" + uploadFile.length);
            for (int i = 0; i < uploadFile.length; i++) {
                MultipartFile file = uploadFile[i];
                InputStream inputStream = null;
                try {
                    inputStream = file.getInputStream();
                } catch (IOException e) {

                    return ResultBody.error(e.getMessage());
                }
                String oldName = file.getOriginalFilename();

                String newName =
                        "file/"
                                + UUID.randomUUID().toString()
                                + oldName.substring(oldName.lastIndexOf("."), oldName.length());
                ossClient.putObject(OssConstant.BUCKET, newName, inputStream);
                // ossClient.shutdown();
                // String filePath = "https://" + OssConstant.BUCKET + '.' +
                // OssConstant.ENDPOINT + "/" +
                // newName;
                list.add("https://" + OssConstant.BUCKET + '.' + OssConstant.ENDPOINT + "/" + newName);
            }
        }
        ossClient.shutdown(); // 关流
        return ResultBody.success(list);
    }

    @ApiOperation(value = "V1.0.1-上传多个视频文件到阿里云oss")
    @ApiImplicitParams({
            @ApiImplicitParam(
                    paramType = "header",
                    name = "mmc-identity",
                    dataTypeClass = java.lang.String.class,
                    dataType = "String",
                    required = false,
                    value = "token"),
            @ApiImplicitParam(
                    name = "uploadFile",
                    dataType = "MultipartFile",
                    dataTypeClass = org.springframework.web.multipart.MultipartFile.class,
                    required = true,
                    value = "视频不能超过1MB/mkv/avi/mov/mp4"),
    })
    @PostMapping("/videoOss")
    public ResultBody videoOss(
            @RequestParam("uploadFile") MultipartFile[] uploadFile, HttpServletRequest request)
            throws IOException {
        ClientBuilderConfiguration clientBuilderConfiguration = new ClientBuilderConfiguration();
        clientBuilderConfiguration.setRequestTimeoutEnabled(true);
        clientBuilderConfiguration.setConnectionRequestTimeout(600000 * 20);
        clientBuilderConfiguration.setConnectionTimeout(600000 * 20);

        OSS ossClient =
                new OSSClientBuilder()
                        .build(
                                OssConstant.ENDPOINT,
                                OssConstant.ACCESSKEYID,
                                OssConstant.ACCESSKEYSECRET,
                                clientBuilderConfiguration);
        List list = new LinkedList();
        if (uploadFile != null && uploadFile.length > 0) {
            System.out.println("osses文件数量" + uploadFile.length);
            for (int i = 0; i < uploadFile.length; i++) {
                MultipartFile file = uploadFile[i];
                InputStream inputStream = null;
                try {
                    inputStream = file.getInputStream();
                } catch (IOException e) {
                    return ResultBody.error(e.getMessage());
                }
                try (final BufferedInputStream bis = new BufferedInputStream(inputStream)) {
                    // 校验
                    int typeNum = FileLoadUtil.checkFileType(FileLoadUtil.getType(bis));
                    if (typeNum != 3) {
                        return ResultBody.error(ResultEnum.UPLOAD_VIDEO_ERROR);
                    }
                    String oldName = file.getOriginalFilename();
                    String newName =
                            "file/"
                                    + UUID.randomUUID().toString()
                                    + oldName.substring(oldName.lastIndexOf("."), oldName.length());
                    ossClient.putObject(OssConstant.BUCKET, newName, bis);
                    System.out.println("视频名称：" + newName);
                    list.add("https://" + OssConstant.BUCKET + '.' + OssConstant.ENDPOINT + "/" + newName);
                }
            }
        }
        ossClient.shutdown(); // 关流
        return ResultBody.success(list);
    }

    @ApiOperation(value = "V1.0.1-上传一个视频文件到阿里云oss")
    @ApiImplicitParams({
            @ApiImplicitParam(
                    paramType = "header",
                    name = "mmc-identity",
                    dataTypeClass = java.lang.String.class,
                    dataType = "String",
                    required = false,
                    value = "token"),
            @ApiImplicitParam(
                    name = "uploadFile",
                    dataType = "MultipartFile",
                    dataTypeClass = org.springframework.web.multipart.MultipartFile.class,
                    required = true,
                    value = "视频不能超过1MB/mkv/avi/mov/mp4"),
    })
    @PostMapping("/videoOsses")
    public ResultBody videoOsses(
            @RequestParam("uploadFile") MultipartFile[] uploadFile, HttpServletRequest request)
            throws IOException {
        ClientBuilderConfiguration clientBuilderConfiguration = new ClientBuilderConfiguration();
        clientBuilderConfiguration.setRequestTimeoutEnabled(true);
        clientBuilderConfiguration.setConnectionRequestTimeout(600000 * 20);
        clientBuilderConfiguration.setConnectionTimeout(600000 * 20);

        OSS ossClient =
                new OSSClientBuilder()
                        .build(
                                OssConstant.ENDPOINT,
                                OssConstant.ACCESSKEYID,
                                OssConstant.ACCESSKEYSECRET,
                                clientBuilderConfiguration);
        Map map = new HashMap();
        if (uploadFile != null && uploadFile.length > 0) {
            System.out.println("osses文件数量" + uploadFile.length);
            for (int i = 0; i < uploadFile.length; i++) {
                MultipartFile file = uploadFile[i];
                InputStream inputStream = null;
                try {
                    inputStream = file.getInputStream();
                } catch (IOException e) {
                    return ResultBody.error(e.getMessage());
                }
                try (final BufferedInputStream bis = new BufferedInputStream(inputStream)) {
                    // 校验
                    int typeNum = FileLoadUtil.checkFileType(FileLoadUtil.getType(bis));
                    if (typeNum != 3) {
                        return ResultBody.error(ResultEnum.UPLOAD_VIDEO_ERROR);
                    }
                    String oldName = file.getOriginalFilename();
                    String newName =
                            "file/"
                                    + UUID.randomUUID().toString()
                                    + oldName.substring(oldName.lastIndexOf("."), oldName.length());
                    ossClient.putObject(OssConstant.BUCKET, newName, bis);
                    System.out.println("视频名称：" + newName);
                    map.put(
                            "filePath",
                            "https://" + OssConstant.BUCKET + '.' + OssConstant.ENDPOINT + "/" + newName);
                    map.put("fileName", oldName);
                    map.put("fileSize", file.getSize());
                    map.put("fileType", oldName.substring(oldName.lastIndexOf(".")).replace(".", ""));
                }
            }
        }
        ossClient.shutdown(); // 关流
        return ResultBody.success(map);
    }

    @ApiOperation(value = "V1.0.1-上传多张图片文件到阿里云oss")
    @ApiImplicitParams({
            @ApiImplicitParam(
                    paramType = "header",
                    name = "mmc-identity",
                    dataTypeClass = java.lang.String.class,
                    dataType = "String",
                    required = false,
                    value = "token"),
            @ApiImplicitParam(
                    name = "uploadFile",
                    dataType = "MultipartFile",
                    dataTypeClass = org.springframework.web.multipart.MultipartFile.class,
                    required = true,
                    value = "图片"),
    })
    @PostMapping("/imgOss")
    public ResultBody imgOss(
            @RequestParam("uploadFile") MultipartFile[] uploadFile, HttpServletRequest request)
            throws IOException {
        OSS ossClient =
                new OSSClientBuilder()
                        .build(OssConstant.ENDPOINT, OssConstant.ACCESSKEYID, OssConstant.ACCESSKEYSECRET);
        List list = new LinkedList();
        if (uploadFile != null && uploadFile.length > 0) {
            System.out.println("osses文件数量" + uploadFile.length);
            for (int i = 0; i < uploadFile.length; i++) {
                MultipartFile file = uploadFile[i];
                InputStream inputStream = null;
                try {
                    inputStream = file.getInputStream();
                } catch (IOException e) {

                    return ResultBody.error(e.getMessage());
                }
                try (final BufferedInputStream bis = new BufferedInputStream(inputStream)) {
                    // 校验
                    int typeNum = FileLoadUtil.checkFileType(FileLoadUtil.getType(bis));
                    if (typeNum != 1) {
                        return ResultBody.error(ResultEnum.UPLOAD_IMG_ERROR);
                    }
                    String oldName = file.getOriginalFilename();
                    String newName =
                            "file/"
                                    + UUID.randomUUID().toString()
                                    + oldName.substring(oldName.lastIndexOf("."), oldName.length());
                    ossClient.putObject(OssConstant.BUCKET, newName, bis);
                    System.out.println("图片名称：" + newName);
                    list.add("https://" + OssConstant.BUCKET + '.' + OssConstant.ENDPOINT + "/" + newName);
                }
            }
        }
        ossClient.shutdown(); // 关流
        return ResultBody.success(list);
    }

    @ApiOperation(value = "V1.0.1-上传一张图片文件到阿里云oss ")
    @ApiImplicitParams({
            @ApiImplicitParam(
                    paramType = "header",
                    name = "mmc-identity",
                    dataTypeClass = java.lang.String.class,
                    dataType = "String",
                    required = false,
                    value = "token"),
            @ApiImplicitParam(
                    name = "uploadFile",
                    dataType = "MultipartFile",
                    dataTypeClass = org.springframework.web.multipart.MultipartFile.class,
                    required = true,
                    value = "文件"),
    })
    @PostMapping("/singleImgOss")
    public ResultBody singleImgOss(
            @RequestParam("uploadFile") MultipartFile uploadFile, HttpServletRequest request)
            throws IOException {
        OSS ossClient =
                new OSSClientBuilder()
                        .build(OssConstant.ENDPOINT, OssConstant.ACCESSKEYID, OssConstant.ACCESSKEYSECRET);
        List list = new LinkedList();
        if (uploadFile != null) {
            if (uploadFile.getSize() / 1024 > 3096) {
                return ResultBody.error("请上传小于3M的图片");
            }
            InputStream inputStream = null;
            try {
                inputStream = uploadFile.getInputStream();
            } catch (IOException e) {

                return ResultBody.error(e.getMessage());
            }
            try (final BufferedInputStream bis = new BufferedInputStream(inputStream)) {
                // 校验
                int typeNum = FileLoadUtil.checkFileType(FileLoadUtil.getType(bis));
                if (typeNum != 1) {
                    return ResultBody.error(ResultEnum.UPLOAD_IMG_ERROR);
                }
                String oldName = uploadFile.getOriginalFilename();
                String newName =
                        "file/"
                                + UUID.randomUUID().toString()
                                + oldName.substring(oldName.lastIndexOf("."), oldName.length());
                ossClient.putObject(OssConstant.BUCKET, newName, bis);
                System.out.println("图片名称：" + newName);
                list.add("https://" + OssConstant.BUCKET + '.' + OssConstant.ENDPOINT + "/" + newName);
            }
        }
        ossClient.shutdown(); // 关流
        return ResultBody.success(list);
    }

    @ApiOperation(value = "V1.0.1-上传一张图片文件到阿里云oss ")
    @ApiImplicitParams({
            @ApiImplicitParam(
                    paramType = "header",
                    name = "mmc-identity",
                    dataTypeClass = java.lang.String.class,
                    dataType = "String",
                    required = false,
                    value = "token"),
            @ApiImplicitParam(
                    name = "uploadFile",
                    dataType = "MultipartFile",
                    dataTypeClass = org.springframework.web.multipart.MultipartFile.class,
                    required = true,
                    value = "图片/返回图片名称及图片大小"),
    })
    @PostMapping("/imgOsses")
    public ResultBody imgOsses(
            @RequestParam("uploadFile") MultipartFile[] uploadFile, HttpServletRequest request)
            throws IOException {
        OSS ossClient =
                new OSSClientBuilder()
                        .build(OssConstant.ENDPOINT, OssConstant.ACCESSKEYID, OssConstant.ACCESSKEYSECRET);
        Map map = new HashMap();
        if (uploadFile != null && uploadFile.length > 0) {
            System.out.println("osses文件数量" + uploadFile.length);
            for (int i = 0; i < uploadFile.length; i++) {
                MultipartFile file = uploadFile[i];
                InputStream inputStream = null;
                try {
                    inputStream = file.getInputStream();
                } catch (IOException e) {

                    return ResultBody.error(e.getMessage());
                }
                try (final BufferedInputStream bis = new BufferedInputStream(inputStream)) {
                    // 校验
                    int typeNum = FileLoadUtil.checkFileType(FileLoadUtil.getType(bis));
                    if (typeNum != 1) {
                        return ResultBody.error(ResultEnum.UPLOAD_IMG_ERROR);
                    }
                    String oldName = file.getOriginalFilename();
                    String newName =
                            "file/"
                                    + UUID.randomUUID().toString()
                                    + oldName.substring(oldName.lastIndexOf("."), oldName.length());
                    ossClient.putObject(OssConstant.BUCKET, newName, bis);
                    System.out.println("图片名称：" + newName);
                    map.put(
                            "filePath",
                            "https://" + OssConstant.BUCKET + '.' + OssConstant.ENDPOINT + "/" + newName);
                    map.put("fileName", oldName);
                    map.put("fileSize", file.getSize());
                    map.put("fileType", oldName.substring(oldName.lastIndexOf(".")).replace(".", ""));
                }
            }
        }
        ossClient.shutdown(); // 关流
        return ResultBody.success(map);
    }

    private byte[] readByte(final InputStream is) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(is);
             ByteArrayOutputStream bas = new ByteArrayOutputStream(4096);
             BufferedOutputStream bos = new BufferedOutputStream(bas)) {
            byte[] bytes = new byte[4096];
            int size;
            while ((size = bis.read(bytes)) != -1) {
                bos.write(bytes, 0, size);
            }
            return bas.toByteArray();
        }
    }

    @ApiOperation(value = "V1.0.1-上传文档文件到阿里云oss")
    @ApiImplicitParams({
            @ApiImplicitParam(
                    paramType = "header",
                    name = "mmc-identity",
                    dataTypeClass = java.lang.String.class,
                    dataType = "String",
                    required = true,
                    value = "token"),
            @ApiImplicitParam(
                    name = "uploadFile",
                    dataType = "MultipartFile",
                    dataTypeClass = org.springframework.web.multipart.MultipartFile.class,
                    required = true,
                    value = "文件 doc,ppt,pdf,xls结尾"),
    })
    @PostMapping("/docOss")
    public ResultBody docOss(
            @RequestParam("uploadFile") MultipartFile[] uploadFile, HttpServletRequest request)
            throws IOException {
        OSS ossClient =
                new OSSClientBuilder()
                        .build(OssConstant.ENDPOINT, OssConstant.ACCESSKEYID, OssConstant.ACCESSKEYSECRET);
        Map map = new HashMap();
        if (uploadFile != null && uploadFile.length > 0) {
            System.out.println("osses文件数量" + uploadFile.length);
            for (int i = 0; i < uploadFile.length; i++) {
                MultipartFile file = uploadFile[i];
                InputStream inputStream = null;
                try {
                    inputStream = file.getInputStream();
                } catch (IOException e) {

                    return ResultBody.error(e.getMessage());
                }
                try (final BufferedInputStream bis = new BufferedInputStream(inputStream)) {
                    // 校验
                    int typeNum = FileLoadUtil.checkFileType(FileLoadUtil.getType(bis));
                    if (typeNum != 2) {
                        return ResultBody.error(ResultEnum.UPLOAD_DOC_ERROR);
                    }
                    String oldName = file.getOriginalFilename();
                    String newName =
                            "file/"
                                    + UUID.randomUUID().toString()
                                    + oldName.substring(oldName.lastIndexOf("."), oldName.length());
                    ossClient.putObject(OssConstant.BUCKET, newName, bis);
                    System.out.println("文档名称：" + newName);

                    map.put(
                            "filePath",
                            "https://" + OssConstant.BUCKET + '.' + OssConstant.ENDPOINT + "/" + newName);
                    map.put("fileName", oldName);
                    map.put("fileSize", file.getSize());
                    map.put("fileType", oldName.substring(oldName.lastIndexOf(".")).replace(".", ""));
                }
            }
        }
        ossClient.shutdown(); // 关流
        return ResultBody.success(map);
    }

    /**
     * 上传文件
     *
     * @param uploadFile
     * @return
     */
    @ApiIgnore
    @RequestMapping(value = "/local", method = RequestMethod.POST)
    public ResultBody local(
            @RequestParam(value = "uploadFile", required = false) MultipartFile[] uploadFile,
            @RequestParam(value = "directory", required = false, defaultValue = "upload")
                    String directory,
            HttpServletRequest request)
            throws IOException {
        return FileLoadUtil.bathCreateFile(directory, uploadFile);
    }

    /**
     * 下载文件
     *
     * @param path
     * @param response
     * @throws IOException
     */
    @ApiIgnore
    @RequestMapping(value = "/download/{path}", method = RequestMethod.GET)
    public void getDownloadFile(@PathVariable("path") String path, HttpServletResponse response)
            throws IOException {
        response.setContentType("application/x-001");
        path = FileLoadUtil.explainLoadPath(path);
        ServletOutputStream out = response.getOutputStream();
        FileInputStream in = new FileInputStream(new File(path));
        byte buffer[] = new byte[1024];
        int length = 0;
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
        in.close();
        out.close();
    }

    @ApiIgnore
    @RequestMapping(value = "/heart", method = RequestMethod.GET)
    public ResultBody heart() {
        return ResultBody.success("heart");
    }
}
