package com.mmc.pms.model.sale.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author LW
 *
 * @date 2022/10/14 11:30 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class MallGoodsDetailDTO implements Serializable {
  private static final long serialVersionUID = 7041502536618388167L;

  @ApiModelProperty(value = "id")
  private Integer id;

  @ApiModelProperty(value = "商品图片")
  private List<GoodsImgDTO> images;

  @ApiModelProperty(value = "商品视频")
  private String goodsVideo;

  @ApiModelProperty(value = "商品视频id")
  private Integer goodsVideoId;

  @ApiModelProperty(value = "商品名称")
  private String goodsName;

  @ApiModelProperty(value = "商品详情")
  private GoodsDetailInfoDTO goodsDetail;

  @ApiModelProperty(value = "所属目录")
  private Integer directoryId;

  @ApiModelProperty(value = "一级分类id")
  private Integer categoryByOne;

  @ApiModelProperty(value = "二级分类id")
  private Integer categoryByTwo;

  @ApiModelProperty(value = "商品标签")
  private String tag;

  @ApiModelProperty(value = "商品状态 0:下架 1:上架")
  private Integer shelfStatus;

  @ApiModelProperty(value = "规格信息")
  private List<GoodsSpecDTO> goodsSpec;

  @ApiModelProperty(value = "其他服务: 1:免费配送，2：专业飞手培训2日， 3：半年保修， 4：一年保修 ")
  private List<GoodsOtherServiceDTO> otherService;

  @ApiModelProperty(value = "price(用于租赁商品)")
  private BigDecimal price;
}
