package com.mmc.pms.controller;

import com.mmc.pms.common.Page;
import com.mmc.pms.common.ResultBody;
import com.mmc.pms.constant.TokenConstant;
import com.mmc.pms.model.lease.dto.LeaseGoodsInfoDTO;
import com.mmc.pms.model.qo.WareInfoQO;
import com.mmc.pms.model.sale.dto.MallGoodsDetailDTO;
import com.mmc.pms.service.WebDeviceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 *
 * @date 2023/6/8 17:16 概要：
 */
@Api(tags = {"v1.0.1-租赁销售-相关接口"})
@RestController
@RequestMapping("/product/mall")
public class ProductMallController extends BaseController {
  @Autowired private WebDeviceService webDeviceService;

  @ApiOperation(value = "设备列表筛选")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = LeaseGoodsInfoDTO.class)})
  @PostMapping("/deviceList")
  public ResultBody listWareInfoPage(
      @RequestBody @Validated(Page.class) WareInfoQO param, HttpServletRequest request) {
    if (request.getHeader(TokenConstant.TOKEN) == null) {
      return webDeviceService.listWareInfoPage(param, null, null);
    }
    return webDeviceService.listWareInfoPage(
        param, request, this.getUserLoginInfoFromRedis(request).getUserAccountId());
  }

  @ApiOperation(value = "设备设备详情")
  @ApiResponses({@ApiResponse(code = 200, message = "OK", response = MallGoodsDetailDTO.class)})
  @GetMapping("/getLeaseGoodsDetail")
  public ResultBody listLeaseGoodsDetail(Integer goodsId, HttpServletRequest request) {
    if (request.getHeader(TokenConstant.TOKEN) == null) {
      return webDeviceService.listLeaseGoodsDetail(goodsId, null, null);
    }
    return webDeviceService.listLeaseGoodsDetail(
        goodsId, this.getUserLoginInfoFromRedis(request).getUserAccountId(), request);
  }
}
